/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.cache.future.FutureMap;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;
import org.gatein.common.io.IOTools;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.ScriptKey;
import org.gatein.portal.controller.resource.ScriptLoader;
import org.gatein.portal.controller.resource.ScriptResult;

public class ResourceRequestHandler
extends WebRequestHandler {
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    private static String PATH = "META-INF/maven/org.exoplatform.portal/exo.portal.component.web.resources/pom.properties";
    private static final Logger log = LoggerFactory.getLogger(ResourceRequestHandler.class);
    public static final String VERSION;
    private static final long MAX_AGE;
    public static final QualifiedName VERSION_QN;
    public static final QualifiedName RESOURCE_QN;
    public static final QualifiedName SCOPE_QN;
    public static final QualifiedName MODULE_QN;
    public static final QualifiedName COMPRESS_QN;
    public static final QualifiedName LANG_QN;
    private final FutureMap<ScriptKey, ScriptResult, ControllerContext> cache = new FutureMap((Loader)new ScriptLoader());

    public String getHandlerName() {
        return "script";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ControllerContext context) throws Exception {
        String resourceParam = context.getParameter(RESOURCE_QN);
        String scopeParam = context.getParameter(SCOPE_QN);
        if (scopeParam != null && resourceParam != null) {
            ResourceScope scope;
            String compressParam = context.getParameter(COMPRESS_QN);
            String lang = context.getParameter(LANG_QN);
            String moduleParam = context.getParameter(MODULE_QN);
            Locale locale = null;
            if (lang != null && lang.length() > 0) {
                locale = I18N.parseTagIdentifier((String)lang);
            }
            try {
                scope = ResourceScope.valueOf(ResourceScope.class, scopeParam);
            }
            catch (IllegalArgumentException e) {
                HttpServletResponse response = context.getResponse();
                String msg = "Unrecognized scope " + scopeParam;
                log.error((Object)msg);
                response.sendError(400, msg);
                return true;
            }
            ResourceId resource = new ResourceId(scope, resourceParam);
            ScriptKey key = new ScriptKey(resource, moduleParam, "min".equals(compressParam), locale);
            ScriptResult result = (ScriptResult)this.cache.get((Object)context, (Object)key);
            HttpServletResponse response = context.getResponse();
            HttpServletRequest request = context.getRequest();
            if (result instanceof ScriptResult.Resolved) {
                ScriptResult.Resolved resolved = (ScriptResult.Resolved)result;
                response.setContentType("text/javascript");
                response.setCharacterEncoding("UTF-8");
                response.setHeader("Cache-Control", "max-age=" + MAX_AGE + ",s-maxage=" + MAX_AGE);
                response.setContentLength(resolved.bytes.length);
                long ifModifiedSince = request.getDateHeader(IF_MODIFIED_SINCE);
                if (resolved.isModified(ifModifiedSince)) {
                    response.setDateHeader(LAST_MODIFIED, resolved.lastModified);
                    ServletOutputStream out = response.getOutputStream();
                    try {
                        out.write(resolved.bytes);
                    }
                    finally {
                        Safe.close((Closeable)out);
                    }
                } else {
                    response.setStatus(304);
                }
            } else if (result instanceof ScriptResult.Error) {
                ScriptResult.Error error = (ScriptResult.Error)result;
                log.error((Object)("Could not render script " + key + "\n:" + error.message));
                response.sendError(500);
            } else {
                String msg = "Resource " + key + " cannot be found";
                log.error((Object)msg);
                response.sendError(404, msg);
            }
        } else {
            HttpServletResponse response = context.getResponse();
            String msg = "Missing scope or resource param";
            log.error((Object)msg);
            response.sendError(400, msg);
        }
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String version = "";
        String property = PropertyManager.getProperty((String)"gatein.assets.version");
        if (property != null && !property.isEmpty()) {
            version = property;
        } else {
            URL url = ResourceRequestHandler.class.getClassLoader().getResource(PATH);
            if (url != null) {
                log.debug((Object)("Loading resource serving version from " + url));
                InputStream in = null;
                try {
                    in = url.openStream();
                    Properties props = new Properties();
                    props.load(in);
                    version = props.getProperty("version");
                }
                catch (IOException e) {
                    log.error((Object)("Could not read properties from " + url), (Throwable)e);
                }
                finally {
                    IOTools.safeClose((Closeable)in);
                }
            }
        }
        log.info((Object)("Use version \"" + version + "\" for resource serving"));
        VERSION = version;
        long seconds = 86400L;
        String propValue = PropertyManager.getProperty((String)"gatein.assets.script.max-age");
        if (propValue != null) {
            try {
                seconds = Long.valueOf(propValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"The gatein.assets.script.max-age property is not set properly.");
            }
        }
        MAX_AGE = seconds;
        VERSION_QN = QualifiedName.create((String)"gtn", (String)"version");
        RESOURCE_QN = QualifiedName.create((String)"gtn", (String)"resource");
        SCOPE_QN = QualifiedName.create((String)"gtn", (String)"scope");
        MODULE_QN = QualifiedName.create((String)"gtn", (String)"module");
        COMPRESS_QN = QualifiedName.create((String)"gtn", (String)"compress");
        LANG_QN = QualifiedName.create((String)"gtn", (String)"lang");
    }
}

