/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.gatein.portal.controller.resource.Resource;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptGraph;

public class ScriptResource
extends Resource<ScriptResource>
implements Comparable<ScriptResource> {
    ScriptGraph graph;
    private final List<Module> modules;
    private final Map<QualifiedName, String> parameters;
    private final Map<Locale, Map<QualifiedName, String>> parametersMap;
    private final Map<QualifiedName, String> minParameters;
    private final Map<Locale, Map<QualifiedName, String>> minParametersMap;
    final HashMap<ResourceId, String> dependencies;
    final HashSet<ResourceId> closure;
    FetchMode fetchMode;
    final String alias;

    ScriptResource(ScriptGraph graph, ResourceId id, FetchMode fetchMode) {
        this(graph, id, fetchMode, null);
    }

    ScriptResource(ScriptGraph graph, ResourceId id, FetchMode fetchMode, String alias) {
        super(id);
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(WebAppController.HANDLER_PARAM, "script");
        parameters.put(ResourceRequestHandler.RESOURCE_QN, id.getName());
        parameters.put(ResourceRequestHandler.SCOPE_QN, id.getScope().name());
        parameters.put(ResourceRequestHandler.COMPRESS_QN, "");
        parameters.put(ResourceRequestHandler.VERSION_QN, ResourceRequestHandler.VERSION);
        parameters.put(ResourceRequestHandler.LANG_QN, "");
        HashMap<QualifiedName, String> minifiedParameters = new HashMap<QualifiedName, String>(parameters);
        minifiedParameters.put(ResourceRequestHandler.COMPRESS_QN, "min");
        this.parameters = parameters;
        this.minParameters = minifiedParameters;
        this.graph = graph;
        this.modules = new ArrayList<Module>();
        this.closure = new HashSet();
        this.dependencies = new HashMap();
        this.fetchMode = fetchMode;
        this.parametersMap = new HashMap<Locale, Map<QualifiedName, String>>();
        this.minParametersMap = new HashMap<Locale, Map<QualifiedName, String>>();
        if (alias == null) {
            String resName = id.getName();
            alias = resName.substring(resName.lastIndexOf("/") + 1);
        }
        this.alias = alias;
    }

    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public Map<QualifiedName, String> getParameters(boolean minified, Locale locale) {
        Map<Locale, Map<QualifiedName, String>> map = minified ? this.minParametersMap : this.parametersMap;
        Locale current = locale;
        while (current != null) {
            Map<QualifiedName, String> ret = map.get(locale);
            if (ret != null) {
                return ret;
            }
            current = I18N.getParent((Locale)current);
        }
        return minified ? this.minParameters : this.parameters;
    }

    public void addDependency(ResourceId dependencyId) {
        this.addDependency(dependencyId, null);
    }

    public void addDependency(ResourceId dependencyId, String alias) {
        ScriptResource dependency = this.graph.getResource(dependencyId);
        if (dependency != null) {
            if (!this.fetchMode.equals((Object)dependency.getFetchMode())) {
                throw new IllegalStateException("ScriptResource " + this.id + " can't depend on " + dependency.getId() + ". They have difference fetchMode");
            }
            if (dependency.closure.contains(this.id)) {
                throw new IllegalStateException("Going to create a cycle");
            }
        }
        if (dependency != null) {
            this.closure.addAll(dependency.getClosure());
        }
        this.closure.add(dependencyId);
        for (Map<String, ScriptResource> resources : this.graph.resources.values()) {
            for (ScriptResource resource : resources.values()) {
                if (!resource.closure.contains(this.id)) continue;
                resource.closure.addAll(this.closure);
            }
        }
        this.dependencies.put(dependencyId, alias);
    }

    public Set<ResourceId> getClosure() {
        return this.closure;
    }

    public Module.Local addLocalModule(String contextPath, String name, String path, String resourceBundle, int priority) {
        Module.Local module = new Module.Local(this, contextPath, name, path, resourceBundle, priority);
        this.modules.add(module);
        return module;
    }

    public Module.Remote addRemoteModule(String contextPath, String name, String path, int priority) {
        Module.Remote module = new Module.Remote(this, contextPath, name, path, priority);
        this.modules.add(module);
        return module;
    }

    public List<Module> removeModuleByName(String name) {
        ArrayList<Module> removed = new ArrayList<Module>();
        Iterator<Module> i = this.modules.iterator();
        while (i.hasNext()) {
            Module module = i.next();
            if (!module.getName().equals(name)) continue;
            removed.add(module);
            i.remove();
        }
        return removed;
    }

    public Module getModule(String name) {
        for (Module module : this.modules) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    public List<Module> removeModuleByContextPath(String contextPath) {
        ArrayList<Module> removed = new ArrayList<Module>();
        Iterator<Module> i = this.modules.iterator();
        while (i.hasNext()) {
            Module module = i.next();
            if (!module.getContextPath().equals(contextPath)) continue;
            removed.add(module);
            i.remove();
        }
        return removed;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public List<String> getModulesNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Module script : this.modules) {
            names.add(script.getName());
        }
        return names;
    }

    @Override
    public int compareTo(ScriptResource o) {
        if (this.closure.contains(o.id)) {
            return 1;
        }
        if (o.closure.contains(this.id)) {
            return -1;
        }
        return 0;
    }

    public void addSupportedLocale(Locale locale) {
        if (!this.parametersMap.containsKey(locale)) {
            HashMap<QualifiedName, String> localizedParameters = new HashMap<QualifiedName, String>(this.parameters);
            localizedParameters.put(ResourceRequestHandler.LANG_QN, I18N.toTagIdentifier((Locale)locale));
            this.parametersMap.put(locale, localizedParameters);
            HashMap<QualifiedName, String> localizedMinParameters = new HashMap<QualifiedName, String>(this.minParameters);
            localizedMinParameters.put(ResourceRequestHandler.LANG_QN, I18N.toTagIdentifier((Locale)locale));
            this.minParametersMap.put(locale, localizedMinParameters);
        }
    }

    @Override
    public Set<ResourceId> getDependencies() {
        return this.dependencies.keySet();
    }

    public String getDependencyAlias(ResourceId id) {
        return this.dependencies.get(id);
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        return "ScriptResource[id=" + this.id + "]";
    }
}

