/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.web.login.GateinWCIController;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.security.TicketConfiguration;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.security.WCIController;

public class InitiateLoginServlet
extends AbstractHttpServlet {
    private static final Logger log = LoggerFactory.getLogger(InitiateLoginServlet.class);
    public static final String COOKIE_NAME = "rememberme";
    private WCIController wciController;
    private ServletContainer servletContainer = DefaultServletContainerFactory.getInstance().getServletContainer();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html; charset=UTF-8");
        Credentials credentials = this.getWCIController().getCredentials(req, resp);
        if (credentials == null) {
            String token = InitiateLoginServlet.getRememberMeTokenCookie(req);
            if (token != null) {
                CookieTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                credentials = tokenService.validateToken(token, false);
                if (credentials == null) {
                    log.debug((Object)("Login initiated with no credentials in session but found token an invalid " + token + " " + "that will be cleared in next response"));
                    Cookie cookie = new Cookie(COOKIE_NAME, "");
                    cookie.setPath(req.getContextPath());
                    cookie.setMaxAge(0);
                    resp.addCookie(cookie);
                    this.getWCIController().showLoginForm(req, resp);
                } else {
                    log.debug((Object)("Login initiated with no credentials in session but found token " + token + " with existing credentials, " + "performing authentication"));
                    this.getWCIController().sendAuth(req, resp, credentials.getUsername(), token);
                }
            } else {
                log.debug((Object)"Login initiated with no credentials in session and no token cookie, redirecting to login page");
                this.getWCIController().showLoginForm(req, resp);
            }
        } else {
            this.servletContainer.login(req, resp, credentials, this.getLoginValidity(), this.wciController.getInitialURI(req));
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public static String getRememberMeTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected boolean requirePortalEnvironment() {
        return true;
    }

    private WCIController getWCIController() {
        if (this.wciController == null) {
            this.wciController = new GateinWCIController(this.getServletContext());
        }
        return this.wciController;
    }

    private long getLoginValidity() {
        return 1000L * TicketConfiguration.getInstance(TicketConfiguration.class).getValidityTime();
    }
}

