/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.security.WCIController;

public class GateinWCIController
extends WCIController {
    private ServletContext servletContext;

    public GateinWCIController(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext is null");
        }
        this.servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLoginForm(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String initialURI = this.getInitialURI(req);
        try {
            String queryString = (String)req.getAttribute("javax.servlet.forward.query_string");
            if (req.getAttribute("javax.servlet.forward.query_string") != null) {
                initialURI = initialURI + "?" + queryString;
            }
            req.setAttribute("org.gatein.portal.login.initial_uri", (Object)initialURI);
            this.servletContext.getRequestDispatcher("/login/jsp/login.jsp").include((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            req.removeAttribute("org.gatein.portal.login.initial_uri");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showErrorLoginForm(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String initialURI = req.getParameter("initialURI");
        if (!(initialURI != null && initialURI.length() != 0 || (initialURI = req.getHeader("referer")) != null && initialURI.length() != 0)) {
            initialURI = req.getContextPath();
        }
        try {
            req.setAttribute("org.gatein.portal.login.initial_uri", (Object)initialURI);
            this.servletContext.getRequestDispatcher("/login/jsp/login.jsp").include((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            req.removeAttribute("org.gatein.portal.login.initial_uri");
        }
    }

    public Credentials getCredentials(HttpServletRequest req, HttpServletResponse resp) {
        AuthenticationRegistry credRegistry = (AuthenticationRegistry)PortalContainer.getCurrentInstance((ServletContext)this.servletContext).getComponentInstanceOfType(AuthenticationRegistry.class);
        Credentials credentials = credRegistry.getCredentials(req);
        if (credentials == null) {
            credentials = (Credentials)req.getSession().getAttribute("authenticatedCredentials");
        }
        return credentials;
    }

    public String getHomeURI(HttpServletRequest req) {
        return req.getContextPath();
    }
}

