/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.web.controller.router.PercentEncoding;
import org.exoplatform.web.login.InitiateLoginServlet;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.text.FastURLEncoder;
import org.gatein.wci.security.Credentials;

public class RememberMeFilter
extends AbstractFilter {
    private static final FastURLEncoder CONVERTER = FastURLEncoder.getUTF8Instance();
    private static final Logger log = LoggerFactory.getLogger(RememberMeFilter.class);

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)req, (HttpServletResponse)resp, chain);
    }

    private void doFilter(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        ExoContainer container;
        Credentials o;
        String token;
        if (req.getRemoteUser() == null && "GET".equals(req.getMethod()) && (token = InitiateLoginServlet.getRememberMeTokenCookie(req)) != null && (o = ((CookieTokenService)(container = this.getContainer()).getComponentInstanceOfType(CookieTokenService.class)).validateToken(token, false)) instanceof Credentials) {
            AuthenticationRegistry authenticationRegistry = (AuthenticationRegistry)this.getContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
            authenticationRegistry.setCredentials(req, o);
            resp.sendRedirect(resp.encodeRedirectURL(this.loginUrl(req.getContextPath(), this.privateUri(req))));
            resp.flushBuffer();
        }
        if (!resp.isCommitted()) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public void destroy() {
    }

    private String privateUri(HttpServletRequest req) {
        StringBuilder builder = new StringBuilder(req.getRequestURI());
        int sep = 63;
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String parameterName = (String)e.nextElement();
            for (String parameteValue : req.getParameterValues(parameterName)) {
                builder.append((char)sep);
                sep = 38;
                builder.append(CONVERTER.encode(parameterName));
                builder.append('=');
                builder.append(CONVERTER.encode(parameteValue));
            }
        }
        return PercentEncoding.QUERY_PARAM.encode((CharSequence)builder);
    }

    private String loginUrl(String context, String initUrl) {
        return String.format("%s/login?initialURI=%s", context, initUrl);
    }
}

