/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.AbstractCodec;
import org.exoplatform.web.security.security.TokenEntry;
import org.gatein.wci.security.Credentials;

@PrimaryType(name="tkn:tokencontainer")
public abstract class TokenContainer {
    @Create
    protected abstract TokenEntry createToken();

    @OneToMany
    protected abstract Map<String, TokenEntry> getTokens();

    public Collection<TokenEntry> getAllTokens() {
        return this.getTokens().values();
    }

    public GateInToken getToken(String tokenId) {
        Map<String, TokenEntry> tokens = this.getTokens();
        TokenEntry entry = tokens.get(tokenId);
        return entry != null ? entry.getToken() : null;
    }

    public GateInToken removeToken(String tokenId) {
        Map<String, TokenEntry> tokens = this.getTokens();
        TokenEntry entry = tokens.get(tokenId);
        if (entry != null) {
            GateInToken token = entry.getToken();
            entry.remove();
            return token;
        }
        return null;
    }

    public GateInToken saveToken(String tokenId, Credentials credentials, Date expirationTime) {
        Map<String, TokenEntry> tokens = this.getTokens();
        TokenEntry entry = tokens.get(tokenId);
        if (entry == null) {
            entry = this.createToken();
            tokens.put(tokenId, entry);
            entry.setUserName(credentials.getUsername());
            entry.setPassword(credentials.getPassword());
        }
        entry.setExpirationTime(expirationTime);
        return entry.getToken();
    }

    public GateInToken encodeAndSaveToken(String tokenId, Credentials credentials, Date expirationTime, AbstractCodec codec) {
        Map<String, TokenEntry> tokens = this.getTokens();
        TokenEntry entry = tokens.get(tokenId);
        if (entry == null) {
            entry = this.createToken();
            tokens.put(tokenId, entry);
            entry.setUserName(credentials.getUsername());
            entry.setPassword(codec.encode(credentials.getPassword()));
        }
        entry.setExpirationTime(expirationTime);
        return entry.getToken();
    }

    public GateInToken getTokenAndDecode(String tokenId, AbstractCodec codec) {
        Map<String, TokenEntry> tokens = this.getTokens();
        TokenEntry entry = tokens.get(tokenId);
        if (entry != null) {
            GateInToken gateInToken = entry.getToken();
            Credentials payload = gateInToken.getPayload();
            return new GateInToken(gateInToken.getExpirationTimeMillis(), new Credentials(payload.getUsername(), codec.decode(payload.getPassword())));
        }
        return null;
    }
}

