/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.download;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadService {
    private final ExoCache<String, DownloadResource> downloadResources_;
    private Map<String, DownloadResource> defaultResources_;
    private PortalContainerInfo pinfo_;
    public static final String DOWNLOAD_HANDLER_PATH = "download";

    public DownloadService(PortalContainerInfo pinfo, InitParams params) throws Exception {
        int maxSize = Integer.parseInt(params.getValueParam("download.resource.cache.size").getValue());
        ConcurrentFIFOExoCache tmp = new ConcurrentFIFOExoCache(maxSize);
        tmp.addCacheListener((CacheListener)new CacheListener<String, DownloadResource>(){

            public void onExpire(CacheListenerContext context, String key, DownloadResource obj) throws Exception {
                if (obj instanceof InputStreamDownloadResource) {
                    try {
                        obj.getInputStream().close();
                    }
                    catch (IOException ioEx) {
                        // empty catch block
                    }
                }
            }

            public void onRemove(CacheListenerContext context, String key, DownloadResource obj) throws Exception {
            }

            public void onPut(CacheListenerContext context, String key, DownloadResource obj) throws Exception {
            }

            public void onGet(CacheListenerContext context, String key, DownloadResource obj) throws Exception {
            }

            public void onClearCache(CacheListenerContext context) throws Exception {
            }
        });
        this.downloadResources_ = tmp;
        this.defaultResources_ = new HashMap<String, DownloadResource>();
        this.pinfo_ = pinfo;
    }

    public void addDefaultDownloadResource(DownloadResource resource) {
        this.defaultResources_.put(resource.getDownloadType(), resource);
    }

    public String addDownloadResource(DownloadResource resource) {
        String id = Integer.toString(resource.hashCode());
        if (resource.getDownloadType() != null) {
            id = resource.getDownloadType() + ":/" + id;
        }
        this.downloadResources_.put((Serializable)((Object)id), (Object)resource);
        return id;
    }

    public DownloadResource getDownloadResource(String id) {
        DownloadResource resource = (DownloadResource)this.downloadResources_.get((Serializable)((Object)id));
        if (resource != null) {
            this.downloadResources_.remove((Serializable)((Object)id));
            return resource;
        }
        String[] temp = id.split(":");
        if (temp.length > 1) {
            String downloadType = temp[0];
            resource = this.defaultResources_.get(downloadType);
        }
        return resource;
    }

    public String getDownloadLink(String id) {
        return "/" + this.pinfo_.getContainerName() + "/" + DOWNLOAD_HANDLER_PATH + "?" + "resourceId=" + id;
    }

    public ExoCache<String, DownloadResource> getCache() {
        return this.downloadResources_;
    }
}

