/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.framework.portlet.mvc;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.javascript.DefaultJavaScriptEngine;
import org.exoplatform.javascript.JavaScriptEngine;
import org.exoplatform.javascript.TemplateContext;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.PortletResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.web.framework.portlet.mvc.EventHandler;

public abstract class MVCPortlet
extends GenericPortlet {
    public static final String EVENT_HANDLER = "EventHandler";
    private DefaultJavaScriptEngine javascriptEngine_;
    private ApplicationResourceResolver resourceResolver_;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.javascriptEngine_ = new DefaultJavaScriptEngine();
        this.resourceResolver_ = new ApplicationResourceResolver();
        this.resourceResolver_.addResourceResolver((ResourceResolver)new PortletResourceResolver(config.getPortletContext(), "app:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processAction(ActionRequest req, ActionResponse res) throws PortletException, IOException {
        EventHandler handler = null;
        try {
            Class<Object> eventHandlerType = this.getDefaultEventHandler();
            String eventHandlerName = req.getParameter(EVENT_HANDLER);
            eventHandlerType = eventHandlerName == null ? this.getDefaultEventHandler() : Thread.currentThread().getContextClassLoader().loadClass(eventHandlerName);
            handler = (EventHandler)eventHandlerType.newInstance();
            TemplateContext context = new TemplateContext((JavaScriptEngine)this.javascriptEngine_, (ResourceResolver)this.resourceResolver_, null);
            handler.setTemplateContext(context);
            handler.setPortletRequest((PortletRequest)req);
            handler.setPortletResponse((PortletResponse)res);
            handler.onAction();
        }
        catch (Throwable ex) {
            handler.setError(ex);
        }
        finally {
            req.getPortletSession().setAttribute(EVENT_HANDLER, (Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(RenderRequest req, RenderResponse res) throws PortletException, IOException {
        res.setContentType("text/html; charset=UTF-8");
        try {
            EventHandler handler = (EventHandler)req.getPortletSession().getAttribute(EVENT_HANDLER);
            if (handler == null) {
                handler = (EventHandler)this.getDefaultEventHandler().newInstance();
                TemplateContext context = new TemplateContext((JavaScriptEngine)this.javascriptEngine_, (ResourceResolver)this.resourceResolver_, null);
                handler.setTemplateContext(context);
            }
            handler.setPortletRequest((PortletRequest)req);
            handler.setPortletResponse((PortletResponse)res);
            handler.onRender();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            req.getPortletSession().removeAttribute(EVENT_HANDLER);
        }
    }

    protected abstract Class getDefaultEventHandler();
}

