/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.exoplatform.web.application.javascript.JSMin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptConfigService {
    private Collection<String> availableScripts_ = new ArrayList<String>();
    private Collection<String> availableScriptsPaths_ = new ArrayList<String>();
    private String mergedJavascript = "";
    private ByteArrayOutputStream jsStream_ = null;

    public Collection<String> getAvailableScripts() {
        return this.availableScripts_;
    }

    public Collection<String> getAvailableScriptsPaths() {
        return this.availableScriptsPaths_;
    }

    public void addJavascript(String module, String scriptPath, ServletContext scontext, String javascript) {
        this.availableScripts_.add(module);
        this.availableScriptsPaths_.add("/" + scontext.getServletContextName() + scriptPath);
        this.mergedJavascript = this.mergedJavascript.concat(javascript).concat("\n");
        this.jsStream_ = null;
    }

    public void addJavascript(String module, String scriptPath, ServletContext scontext) {
        String servletContextName = scontext.getServletContextName();
        this.availableScripts_.add(module);
        this.availableScriptsPaths_.add("/" + servletContextName + scriptPath);
        String javascript = this.loadJavascript(scriptPath, scontext);
        this.mergedJavascript = this.mergedJavascript.concat(javascript);
    }

    public void removeJavaScript(String module, String scriptPath, ServletContext scontext) {
        String servletContextName = scontext.getServletContextName();
        this.availableScripts_.remove(module);
        this.availableScriptsPaths_.remove("/" + servletContextName + scriptPath);
        StringBuilder sB = new StringBuilder();
        for (String key : this.availableScriptsPaths_) {
            int index = key.indexOf("/", 1);
            String contextName = key.substring(0, index);
            String jsPath = key.substring(index);
            try {
                ServletContext servletContext = scontext.getContext(contextName);
                String javascript = this.loadJavascript(jsPath, servletContext);
                sB.append(javascript);
            }
            catch (Exception e) {}
        }
        this.mergedJavascript = sB.toString();
        this.jsStream_ = null;
    }

    public byte[] getMergedJavascript() {
        if (this.jsStream_ == null) {
            this.jsStream_ = new ByteArrayOutputStream();
            ByteArrayInputStream input = new ByteArrayInputStream(this.mergedJavascript.getBytes());
            JSMin jsMin = new JSMin(input, this.jsStream_);
            try {
                jsMin.jsmin();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.jsStream_.toByteArray();
    }

    public boolean isModuleLoaded(CharSequence module) {
        return this.getAvailableScripts().contains(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadJavascript(String scriptPath, ServletContext scontext) {
        StringBuffer sB = new StringBuffer();
        String line = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(scontext.getResourceAsStream(scriptPath)));
            try {
                while ((line = reader.readLine()) != null) {
                    sB.append(line + "\n");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sB.append("\n");
        return sB.toString();
    }
}

