/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.download;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;

public class DownloadService {
    private Cache downloadResources_;
    private Map<String, DownloadResource> defaultResources_;
    private PortalContainerInfo pinfo_;

    public DownloadService(PortalContainerInfo pinfo, InitParams params) throws Exception {
        int maxSize = Integer.parseInt(params.getValueParam("download.resource.cache.size").getValue());
        this.downloadResources_ = new Cache(maxSize);
        this.defaultResources_ = new HashMap<String, DownloadResource>();
        this.pinfo_ = pinfo;
    }

    public void addDefaultDownloadResource(DownloadResource resource) {
        this.defaultResources_.put(resource.getDownloadType(), resource);
    }

    public String addDownloadResource(DownloadResource resource) {
        String id = Integer.toString(resource.hashCode());
        if (resource.getDownloadType() != null) {
            id = resource.getDownloadType() + ":/" + id;
        }
        this.downloadResources_.put(id, resource);
        return id;
    }

    public DownloadResource getDownloadResource(String id) {
        DownloadResource resource = (DownloadResource)this.downloadResources_.get(id);
        if (resource != null) {
            this.downloadResources_.remove(id);
            return resource;
        }
        String[] temp = id.split(":");
        if (temp.length > 1) {
            String downloadType = temp[0];
            resource = this.defaultResources_.get(downloadType);
        }
        return resource;
    }

    public String getDownloadLink(String id) {
        return "/" + this.pinfo_.getContainerName() + "/command?" + "type=org.exoplatform.web.command.handler.DownloadHandler&amp;resourceId=" + id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Cache
    extends LinkedHashMap<String, DownloadResource> {
        int maxSize_ = 100;

        public Cache(int maxSize) {
            this.maxSize_ = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, DownloadResource> eldest) {
            return this.size() > this.maxSize_;
        }
    }
}

