/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.upload.RequestStreamReader;
import org.exoplatform.upload.UploadResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadService {
    private Map<String, UploadResource> uploadResources = new LinkedHashMap<String, UploadResource>();
    private String uploadLocation_;
    private int defaultUploadLimitMB_;
    private Map<String, Integer> uploadLimitsMB_ = new LinkedHashMap<String, Integer>();

    public UploadService(PortalContainerInfo pinfo, InitParams params) throws Exception {
        String tmpDir = System.getProperty("java.io.tmpdir");
        this.defaultUploadLimitMB_ = params == null || params.getValueParam("upload.limit.size") == null ? 0 : Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
        this.uploadLocation_ = tmpDir + "/" + pinfo.getContainerName() + "/eXoUpload";
        File uploadDir = new File(this.uploadLocation_);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
    }

    public void createUploadResource(HttpServletRequest request) throws IOException {
        String uploadId = request.getParameter("uploadId");
        int limitMB = this.uploadLimitsMB_.get(uploadId);
        UploadResource upResource = new UploadResource(uploadId);
        RequestStreamReader reader = new RequestStreamReader(upResource);
        int estimatedSizeMB = request.getContentLength() / 1024 / 1024;
        if (limitMB > 0 && estimatedSizeMB > limitMB) {
            upResource.setStatus(2);
            this.uploadResources.put(upResource.getUploadId(), upResource);
            System.out.println("Upload cancelled because file bigger than size limit : " + estimatedSizeMB + " MB > " + limitMB + " MB");
            return;
        }
        String headerEncoding = request.getCharacterEncoding();
        Map<String, String> headers = reader.parseHeaders((InputStream)request.getInputStream(), headerEncoding);
        String fileName = reader.getFileName(headers);
        if (fileName == null) {
            fileName = uploadId;
        }
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        upResource.setFileName(fileName);
        upResource.setMimeType(headers.get("content-type"));
        upResource.setStoreLocation(this.uploadLocation_ + "/" + uploadId + "." + fileName);
        upResource.setEstimatedSize(request.getContentLength());
        this.uploadResources.put(upResource.getUploadId(), upResource);
        File fileStore = new File(upResource.getStoreLocation());
        if (!fileStore.exists()) {
            fileStore.createNewFile();
        }
        FileOutputStream output = new FileOutputStream(fileStore);
        reader.readBodyData(request, output);
        if (upResource.getStatus() == 0) {
            upResource.setStatus(1);
            return;
        }
        this.uploadResources.remove(uploadId);
        fileStore.delete();
    }

    public void createUploadResource(String uploadId, String encoding, String contentType, double contentLength, InputStream inputStream) throws Exception {
        UploadResource upResource = new UploadResource(uploadId);
        RequestStreamReader reader = new RequestStreamReader(upResource);
        Map<String, String> headers = reader.parseHeaders(inputStream, encoding);
        String fileName = reader.getFileName(headers);
        if (fileName == null) {
            fileName = uploadId;
        }
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        upResource.setFileName(fileName);
        upResource.setMimeType(headers.get("content-type"));
        upResource.setStoreLocation(this.uploadLocation_ + "/" + uploadId + "." + fileName);
        upResource.setEstimatedSize(contentLength);
        this.uploadResources.put(upResource.getUploadId(), upResource);
        File fileStore = new File(upResource.getStoreLocation());
        if (!fileStore.exists()) {
            fileStore.createNewFile();
        }
        FileOutputStream output = new FileOutputStream(fileStore);
        reader.readBodyData(inputStream, contentType, output);
        if (upResource.getStatus() == 0) {
            upResource.setStatus(1);
            return;
        }
        this.uploadResources.remove(uploadId);
        fileStore.delete();
    }

    public UploadResource getUploadResource(String uploadId) {
        UploadResource upResource = this.uploadResources.get(uploadId);
        return upResource;
    }

    public void removeUpload(String uploadId) {
        if (uploadId == null) {
            return;
        }
        UploadResource upResource = this.uploadResources.get(uploadId);
        if (upResource == null) {
            return;
        }
        File file = new File(upResource.getStoreLocation());
        file.delete();
        this.uploadResources.remove(uploadId);
        this.uploadLimitsMB_.remove(uploadId);
    }

    public void addUploadLimit(String uploadId, Integer limitMB) {
        if (limitMB == null) {
            this.uploadLimitsMB_.put(uploadId, this.defaultUploadLimitMB_);
        } else {
            this.uploadLimitsMB_.put(uploadId, limitMB);
        }
    }

    public Map<String, Integer> getUploadLimitsMB() {
        return this.uploadLimitsMB_;
    }
}

