/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.web.security.Credentials;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.security.TransientTokenService;

public class InitiateLoginServlet
extends HttpServlet {
    public static final String COOKIE_NAME = "rememberme";
    public static final String CREDENTIALS = "credentials";

    /*
     * Enabled aggressive block sorting
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AbstractTokenService tokenService;
        String token;
        HttpSession session = req.getSession();
        Credentials credentials = (Credentials)session.getAttribute(CREDENTIALS);
        session.setAttribute("initialURI", req.getAttribute("javax.servlet.forward.request_uri"));
        if (credentials == null) {
            token = this.getTokenCookie(req);
            if (token == null) {
                req.getRequestDispatcher("/login/jsp/login.jsp").include((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
            credentials = tokenService.validateToken(token, false);
            if (credentials == null) {
                Cookie cookie = new Cookie(COOKIE_NAME, "");
                cookie.setPath(req.getContextPath());
                cookie.setMaxAge(0);
                resp.addCookie(cookie);
                req.getRequestDispatcher("/login/jsp/login.jsp").include((ServletRequest)req, (ServletResponse)resp);
                return;
            }
        } else {
            req.getSession().removeAttribute(CREDENTIALS);
        }
        token = null;
        for (Cookie cookie : req.getCookies()) {
            if (!COOKIE_NAME.equals(cookie.getName())) continue;
            token = cookie.getValue();
            break;
        }
        if (token == null) {
            tokenService = AbstractTokenService.getInstance(TransientTokenService.class);
            token = ((TransientTokenService)tokenService).createToken(credentials);
        }
        this.sendAuth(resp, credentials.getUsername(), token);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void sendAuth(HttpServletResponse resp, String jUsername, String jPassword) throws IOException {
        String url = "j_security_check?j_username=" + jUsername + "&j_password=" + jPassword;
        url = resp.encodeRedirectURL(url);
        resp.sendRedirect(url);
    }

    private String getTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

