/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.exoplatform.web.security.Credentials;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.security.TransientTokenService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalLoginModule
implements LoginModule {
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map<String, ?> sharedState;
    protected Map<String, ?> options;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            Credentials o = AbstractTokenService.getInstance(TransientTokenService.class).validateToken(password, true);
            if (o == null) {
                o = AbstractTokenService.getInstance(CookieTokenService.class).validateToken(password, false);
            }
            if (o instanceof Credentials) {
                Credentials wc = o;
                this.sharedState.put("javax.security.auth.login.name", wc.getUsername());
                this.sharedState.put("javax.security.auth.login.password", wc.getPassword());
            }
            return true;
        }
        catch (Exception e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

