/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.web.security.Credentials;
import org.exoplatform.web.security.Token;
import org.exoplatform.web.security.TokenStore;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="auth_token"), @Property(key="name", value="{Name}")})
@ManagedDescription(value="Token Service")
public abstract class AbstractTokenService
implements Startable,
TokenStore {
    protected final String SERVICE_CONFIG = "service.configuration";
    protected static final int DELAY_TIME = 600;
    protected final Random random = new Random();
    protected String name;
    protected long validityMillis;

    public AbstractTokenService(InitParams initParams) {
        ArrayList params = initParams.getValuesParam("service.configuration").getValues();
        this.name = (String)params.get(0);
        long configValue = new Long((String)params.get(1));
        this.validityMillis = TimeoutEnum.valueOf((String)params.get(2)).toMilisecond(configValue);
    }

    public void start() {
        final AbstractTokenService service = this;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                try {
                    service.cleanExpiredTokens();
                }
                catch (RepositoryException re) {
                    System.out.println("Error occur when delete expired cookie token");
                }
            }
        }, 0L, 600L, TimeUnit.SECONDS);
    }

    public void stop() {
    }

    public static <T extends AbstractTokenService> T getInstance(Class<T> classType) {
        PortalContainer container = PortalContainer.getInstance();
        return (T)((AbstractTokenService)container.getComponentInstanceOfType(classType));
    }

    @Override
    public Credentials validateToken(String tokenKey, boolean remove) {
        if (tokenKey == null) {
            throw new NullPointerException();
        }
        try {
            Token token = remove ? this.deleteToken(tokenKey) : this.getToken(tokenKey);
            if (token != null) {
                boolean valid;
                boolean bl = valid = token.getExpirationTimeMillis() > System.currentTimeMillis();
                if (valid) {
                    return token.getPayload();
                }
                if (!remove) {
                    this.deleteToken(tokenKey);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    @Managed
    @ManagedDescription(value="Clean all tokens are expired")
    public void cleanExpiredTokens() throws PathNotFoundException, RepositoryException {
        String[] ids;
        for (String s : ids = this.getAllTokens()) {
            Token token = this.getToken(s);
            if (!token.isExpired()) continue;
            this.deleteToken(s);
        }
    }

    @Managed
    @ManagedDescription(value="Get period time of expired token")
    public long getExpiredPeriodTime() {
        return this.validityMillis;
    }

    @Managed
    @ManagedName(value="Name")
    @ManagedDescription(value="The token service name")
    public String getName() {
        return this.name;
    }

    @Managed
    @ManagedDescription(value="get a token by id")
    public abstract Token getToken(String var1) throws PathNotFoundException, RepositoryException;

    @Managed
    @ManagedDescription(value="Delete a token by id")
    public abstract Token deleteToken(String var1) throws PathNotFoundException, RepositoryException;

    @Managed
    @ManagedDescription(value="The list of all tokens")
    public abstract String[] getAllTokens();

    @Managed
    @ManagedDescription(value="The number of tokens")
    public abstract long getNumberTokens() throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TimeoutEnum {
        SECOND(1000L),
        MINUTE(60000L),
        HOUR(3600000L),
        DAY(86400000L);

        private long multiply;

        private TimeoutEnum(long multiply) {
            this.multiply = multiply;
        }

        public long toMilisecond(long configValue) {
            return configValue * this.multiply;
        }
    }
}

