/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.web.security.Credentials;
import org.exoplatform.web.security.Token;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CookieTokenService
extends AbstractTokenService {
    private RegistryService regService_;

    public CookieTokenService(InitParams initParams, RegistryService rService) {
        super(initParams);
        this.regService_ = rService;
    }

    public String createToken(Credentials credentials) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (credentials == null) {
            throw new NullPointerException();
        }
        String tokenId = "rememberme" + this.random.nextInt();
        long expirationTimeMillis = System.currentTimeMillis() + this.validityMillis;
        this.saveToken(tokenId, new Token(expirationTimeMillis, credentials));
        return tokenId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken(String id) throws PathNotFoundException, RepositoryException {
        String entryPath = this.getServiceRegistryPath() + "/" + id;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
            Token token = this.toToken(entry.getDocument());
            return token;
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token deleteToken(String id) throws PathNotFoundException, RepositoryException {
        Token data = this.getToken(id);
        if (data == null) {
            return null;
        }
        String entryPath = this.getServiceRegistryPath() + "/" + id;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            this.regService_.removeEntry(sessionProvider, entryPath);
            Token token = data;
            return token;
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToken(String tokenId, Token token) {
        if (tokenId == null || tokenId.length() == 0 || token == null) {
            return;
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String servicePath = this.getServiceRegistryPath();
        String entryPath = servicePath + "/" + tokenId;
        try {
            RegistryEntry entry;
            try {
                entry = this.regService_.getEntry(sessionProvider, entryPath);
            }
            catch (PathNotFoundException e) {
                entry = new RegistryEntry(tokenId);
                this.regService_.createEntry(sessionProvider, servicePath, entry);
            }
            Document doc = entry.getDocument();
            this.map(doc, token);
            this.regService_.recreateEntry(sessionProvider, servicePath, entry);
        }
        catch (Exception e) {
        }
        finally {
            sessionProvider.close();
        }
    }

    private Token toToken(Document document) {
        Element root = document.getDocumentElement();
        String userName = root.getAttribute(Token.USERNAME);
        String password = root.getAttribute(Token.PASSWORD);
        long time = Long.parseLong(root.getAttribute(Token.EXPIRE_MILI));
        Credentials payload = new Credentials(userName, password);
        return new Token(time, payload);
    }

    private void map(Document document, Token token) {
        Element root = document.getDocumentElement();
        this.prepareXmlNamespace(root);
        root.setAttribute(Token.EXPIRE_MILI, "" + token.getExpirationTimeMillis());
        root.setAttribute(Token.USERNAME, token.getPayload().getUsername());
        root.setAttribute(Token.PASSWORD, token.getPayload().getPassword());
    }

    private void prepareXmlNamespace(Element element) {
        this.setXmlNameSpace(element, "xmlns:exo", "http://www.exoplatform.com/jcr/exo/1.0");
        this.setXmlNameSpace(element, "xmlns:jcr", "http://www.jcp.org/jcr/1.0");
    }

    private void setXmlNameSpace(Element element, String key, String value) {
        String xmlns = element.getAttribute(key);
        if (xmlns == null || xmlns.trim().length() < 1) {
            element.setAttribute(key, value);
        }
    }

    private String getServiceRegistryPath() {
        return "exo:services/" + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllTokens() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
            NodeIterator itr = regNode.getNode(this.getServiceRegistryPath()).getNodes();
            ArrayList<String> list = new ArrayList<String>();
            while (itr.hasNext()) {
                Node node = itr.nextNode();
                list.add(node.getName());
            }
            String[] stringArray = list.toArray(new String[0]);
            return stringArray;
        }
        catch (RepositoryException e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberTokens() throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
            NodeIterator itr = regNode.getNode(this.getServiceRegistryPath()).getNodes();
            long l = itr.getSize();
            return l;
        }
        catch (Exception ex) {
            long l = 0L;
            return l;
        }
        finally {
            sessionProvider.close();
        }
    }
}

