/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.web.security.Credentials;
import org.exoplatform.web.security.Token;
import org.exoplatform.web.security.security.AbstractTokenService;

public class TransientTokenService
extends AbstractTokenService {
    protected final ConcurrentHashMap<String, Token> tokens = new ConcurrentHashMap();

    public TransientTokenService(InitParams initParams) {
        super(initParams);
    }

    public String createToken(Credentials credentials) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (credentials == null) {
            throw new NullPointerException();
        }
        String tokenId = "rememberme" + this.random.nextInt();
        long expirationTimeMillis = System.currentTimeMillis() + this.validityMillis;
        this.tokens.put(tokenId, new Token(expirationTimeMillis, credentials));
        return tokenId;
    }

    public Token getToken(String id) throws PathNotFoundException, RepositoryException {
        return this.tokens.get(id);
    }

    public Token deleteToken(String id) throws PathNotFoundException, RepositoryException {
        Token token = this.tokens.get(id);
        this.tokens.remove(id);
        return token;
    }

    public String[] getAllTokens() {
        return this.tokens.keySet().toArray(new String[0]);
    }

    public long getNumberTokens() throws Exception {
        return this.tokens.size();
    }
}

