/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.refs;

import org.exoplatform.services.chars.CharsUtil;
import org.exoplatform.services.html.refs.CharRef;
import org.exoplatform.services.html.refs.CharRefs;
import org.exoplatform.services.html.refs.CharsSequence;
import org.exoplatform.services.html.refs.DecodeService;

public class RefsDecoder {
    public String decode(String text) {
        return new String(this.decodeChars(text.toCharArray()));
    }

    public char[] decode(char[] chars) {
        return this.decodeChars(chars);
    }

    private char[] decodeChars(char[] chars) {
        int index;
        CharRefs charRefs = DecodeService.DECODE_CHARS_REF.getRef();
        if (!charRefs.isSorted()) {
            charRefs.sort(DecodeService.comparator);
        }
        if ((index = CharsUtil.indexOf(chars, '&', 0)) < 0 || CharsUtil.indexOf(chars, ';', index) < 0) {
            return chars;
        }
        CharsSequence decode = new CharsSequence(chars.length);
        int temp = 0;
        int end = 0;
        boolean ref = true;
        char[] ckey = null;
        while (index < chars.length) {
            if (temp < index) {
                this.copy(chars, decode, temp, index);
            }
            if ((end = CharsUtil.indexOf(chars, ';', index)) < 0) break;
            if (chars[index + 1] == '#') {
                ckey = new char[end - index - 2];
                System.arraycopy(chars, index + 2, ckey, 0, ckey.length);
                ref = false;
            } else {
                ckey = new char[end - index - 1];
                System.arraycopy(chars, index + 1, ckey, 0, ckey.length);
                ref = true;
            }
            if (!ref) {
                ref = this.decode(ckey, decode);
            } else if (Character.isLetter(ckey[0])) {
                CharRef item = charRefs.searchByName(new String(ckey), DecodeService.comparator);
                if (item != null) {
                    decode.append((char)item.getValue());
                } else {
                    this.copy(chars, decode, index, end + 1);
                }
            } else {
                this.copy(chars, decode, index, end);
            }
            if ((index = CharsUtil.indexOf(chars, '&', temp = end + 1)) >= 0) continue;
        }
        this.copy(chars, decode, temp, chars.length);
        return decode.getValues();
    }

    private void copy(char[] chars, CharsSequence decode, int start, int end) {
        while (start < chars.length && start != end) {
            decode.append(chars[start]);
            ++start;
        }
    }

    private boolean decode(char[] values, CharsSequence decode) {
        int number = 0;
        int radix = 0;
        boolean done = false;
        int i = 0;
        while (i < values.length && !done) {
            char character = values[i];
            if (Character.isDigit(character)) {
                if (radix == 0) {
                    radix = 10;
                }
                number = number * radix + (character - 48);
            } else {
                switch (character) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        if (radix == 16) {
                            number = number * radix + (character - 65 + 10);
                            break;
                        }
                        done = true;
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (radix == 16) {
                            number = number * radix + (character - 97 + 10);
                            break;
                        }
                        done = true;
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        if (radix == 0) {
                            radix = 16;
                            break;
                        }
                        done = true;
                        break;
                    }
                    case ';': {
                        done = true;
                        ++i;
                        break;
                    }
                    default: {
                        done = true;
                    }
                }
            }
            if (done) continue;
            ++i;
        }
        if (number == 0) {
            return true;
        }
        decode.append((char)number);
        return false;
    }
}

