/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.path;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.html.HTMLDocument;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.parser.HTMLParser;
import org.exoplatform.services.html.path.NodePath;
import org.exoplatform.services.html.path.NodePathParser;

public class NodePathUtil {
    public static synchronized NodePath[] toNodePath(String[] paths) throws Exception {
        NodePath[] values = new NodePath[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            values[i] = NodePathParser.toPath(paths[i]);
        }
        return values;
    }

    public static synchronized void remove(HTMLNode root, NodePath[] paths) {
        if (paths == null) {
            return;
        }
        ArrayList<HTMLNode> list = new ArrayList<HTMLNode>();
        for (NodePath path : paths) {
            HTMLNode element = NodePathUtil.lookFor(root, path);
            if (element == null) continue;
            list.add(element);
        }
        for (HTMLNode element : list) {
            HTMLNode parent = element.getParent();
            parent.getChildren().remove(element);
        }
    }

    public static synchronized HTMLDocument create(HTMLNode root, NodePath[] paths) {
        HTMLNode html = HTMLParser.clone(root);
        for (NodePath path : paths) {
            HTMLNode element = NodePathUtil.lookFor(root, path);
            if (element == null) continue;
            html.addChild(element);
        }
        HTMLDocument document = new HTMLDocument();
        document.setRoot(html);
        return document;
    }

    public static synchronized HTMLNode lookFor(HTMLNode root, NodePath path) {
        int count;
        if (path == null) {
            return null;
        }
        NodePath.Index[] indexs = path.getIndexs();
        List<HTMLNode> children = root.getChildren();
        if (children == null) {
            return null;
        }
        block0: for (int i = 0; i < indexs.length - 1; ++i) {
            count = 0;
            for (int j = 0; j < children.size(); ++j) {
                if (!children.get(j).isNode(indexs[i].getName())) continue;
                if (indexs[i].getIdx() == count) {
                    root = children.get(j);
                    children = root.getChildren();
                    continue block0;
                }
                ++count;
            }
        }
        count = 0;
        for (int j = 0; j < children.size(); ++j) {
            if (!children.get(j).isNode(indexs[indexs.length - 1].getName())) continue;
            if (indexs[indexs.length - 1].getIdx() == count) {
                return children.get(j);
            }
            ++count;
        }
        return null;
    }
}

