/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.NodeConfig;
import org.exoplatform.services.html.parser.HTML;
import org.exoplatform.services.html.parser.NodeImpl;
import org.exoplatform.services.html.parser.ParserService;
import org.exoplatform.services.token.TypeToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NodeCreator {
    private List<NodeImpl> opens = new ArrayList<NodeImpl>();

    NodeCreator() {
    }

    List<NodeImpl> getOpens() {
        return this.opens;
    }

    NodeImpl getLast() {
        return this.opens.get(this.opens.size() - 1);
    }

    NodeImpl getOpenParent(NodeConfig config, boolean create) {
        ArrayList<Name[]> list = new ArrayList<Name[]>();
        while (config.parent().length > 0) {
            list.add(0, config.parent());
            config = HTML.getConfig(config.parent()[0]);
        }
        if (this.opens.size() < 1) {
            return null;
        }
        if (list.size() < 1) {
            return this.opens.get(this.opens.size() - 1);
        }
        NodeImpl parent = this.opens.get(this.opens.size() - 1);
        NodeImpl impl = null;
        Iterator iter = list.iterator();
        boolean start = false;
        while (iter.hasNext()) {
            Name[] names = (Name[])iter.next();
            if (start) {
                NodeImpl child;
                List<HTMLNode> children = parent.getChildrenNode();
                block2: for (int i = children.size() - 1; i > -1 && (child = (NodeImpl)children.get(i)).isOpen(); --i) {
                    for (Name name : names) {
                        if (child.getName() != name) continue;
                        impl = child;
                        continue block2;
                    }
                }
            } else {
                impl = this.getOpenNode(names);
            }
            if (impl == null) {
                if (create) {
                    return this.createNode(list, parent);
                }
                return null;
            }
            parent = impl;
            impl = null;
            iter.remove();
            start = true;
        }
        return parent;
    }

    private NodeImpl createNode(List<Name[]> list, NodeImpl parent) {
        NodeImpl child = null;
        for (Name[] names : list) {
            Name name = names[0];
            child = new NodeImpl(name.toString().toCharArray(), name, TypeToken.TAG);
            if (child.getConfig().only()) {
                parent = ParserService.getNodeSetter().set(child);
                continue;
            }
            parent.addChild(child);
            child.setParent(parent);
            this.opens.add(child);
            parent = child;
        }
        return parent;
    }

    private NodeImpl getOpenNode(Name[] names) {
        for (int i = this.opens.size() - 1; i > -1; --i) {
            for (Name name : names) {
                if (this.opens.get(i).getConfig().name() != name) continue;
                return this.opens.get(i);
            }
            if (this.opens.get(i).getConfig().block()) break;
        }
        return null;
    }
}

