/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.handlers.InvocationHandler;
import org.gatein.wsrp.consumer.handlers.NavigationalStateUpdatingHandler;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UploadContext;
import org.oasis.wsrp.v2.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionHandler
extends NavigationalStateUpdatingHandler<ActionInvocation, PerformBlockingInteraction, BlockingInteractionResponse> {
    public ActionHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    @Override
    protected RuntimeContext getRuntimeContextFrom(PerformBlockingInteraction performBlockingInteraction) {
        return performBlockingInteraction.getRuntimeContext();
    }

    @Override
    protected BlockingInteractionResponse performRequest(PerformBlockingInteraction interaction) throws Exception {
        Holder updateResponseHolder = new Holder();
        Holder redirectURL = new Holder();
        if (debug) {
            log.debug("performBlockingInteraction on '" + interaction.getPortletContext().getPortletHandle() + "'");
        }
        this.consumer.getMarkupService().performBlockingInteraction(interaction.getRegistrationContext(), interaction.getPortletContext(), interaction.getRuntimeContext(), interaction.getUserContext(), interaction.getMarkupParams(), interaction.getInteractionParams(), (Holder<UpdateResponse>)updateResponseHolder, (Holder<String>)redirectURL, (Holder<List<Extension>>)new Holder());
        if (redirectURL.value != null) {
            return WSRPTypeFactory.createBlockingInteractionResponse((String)((String)redirectURL.value));
        }
        return WSRPTypeFactory.createBlockingInteractionResponse((UpdateResponse)((UpdateResponse)updateResponseHolder.value));
    }

    @Override
    protected PerformBlockingInteraction prepareRequest(InvocationHandler.RequestPrecursor<ActionInvocation> requestPrecursor, ActionInvocation invocation) {
        String state;
        if (!(invocation instanceof ActionInvocation)) {
            throw new IllegalArgumentException("ActionHandler can only handle ActionInvocations!");
        }
        ActionInvocation actionInvocation = invocation;
        PortletContext portletContext = requestPrecursor.getPortletContext();
        if (debug) {
            log.debug("Consumer about to attempt action on portlet '" + portletContext.getPortletHandle() + "'");
        }
        InstanceContext instanceContext = invocation.getInstanceContext();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)instanceContext, (String)"instance context");
        AccessMode accessMode = instanceContext.getAccessMode();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)accessMode, (String)"access mode");
        if (debug) {
            log.debug("Portlet is requesting " + accessMode + " access mode");
        }
        InteractionParams interactionParams = WSRPTypeFactory.createInteractionParams((StateChange)WSRPUtils.getStateChangeFromAccessMode((AccessMode)accessMode));
        StateString interactionState = actionInvocation.getInteractionState();
        if (interactionState != null && !"JBPNS_".equals(state = interactionState.getStringValue())) {
            interactionParams.setInteractionState(state);
        }
        RequestContextWrapper requestContext = new RequestContextWrapper(actionInvocation.getRequestContext());
        try {
            if (FileUpload.isMultipartContent((org.apache.commons.fileupload.RequestContext)requestContext)) {
                FileUpload upload = new FileUpload();
                FileItemIterator iter = upload.getItemIterator((org.apache.commons.fileupload.RequestContext)requestContext);
                ArrayList<UploadContext> uploadContexts = new ArrayList<UploadContext>(7);
                ArrayList<NamedString> formParameters = new ArrayList<NamedString>(7);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    InputStream stream = item.openStream();
                    if (!item.isFormField()) {
                        String contentType = item.getContentType();
                        if (debug) {
                            log.debug("File field " + item.getFieldName() + " with file name " + item.getName() + " and content type " + contentType + " detected.");
                        }
                        BufferedInputStream bufIn = new BufferedInputStream(stream);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        BufferedOutputStream bos = new BufferedOutputStream(baos);
                        int c = bufIn.read();
                        while (c != -1) {
                            bos.write(c);
                            c = bufIn.read();
                        }
                        bos.flush();
                        baos.flush();
                        bufIn.close();
                        bos.close();
                        UploadContext uploadContext = WSRPTypeFactory.createUploadContext((String)contentType, (byte[])baos.toByteArray());
                        ArrayList<NamedString> mimeAttributes = new ArrayList<NamedString>(2);
                        String value = "form-data; name=\"" + item.getFieldName() + "\";" + " filename=\"" + item.getName() + "\"";
                        NamedString mimeAttribute = WSRPTypeFactory.createNamedString((String)"Content-disposition", (String)value);
                        mimeAttributes.add(mimeAttribute);
                        mimeAttribute = WSRPTypeFactory.createNamedString((String)"Content-type", (String)item.getContentType());
                        mimeAttributes.add(mimeAttribute);
                        uploadContext.getMimeAttributes().addAll(mimeAttributes);
                        uploadContexts.add(uploadContext);
                        continue;
                    }
                    NamedString formParameter = WSRPTypeFactory.createNamedString((String)item.getFieldName(), (String)Streams.asString((InputStream)stream));
                    formParameters.add(formParameter);
                }
                interactionParams.getUploadContexts().addAll(uploadContexts);
                interactionParams.getFormParameters().addAll(formParameters);
            } else {
                Map params = actionInvocation.getForm();
                if (params != null && !params.isEmpty()) {
                    int capacity = params.size();
                    ArrayList<NamedString> formParameters = new ArrayList<NamedString>(capacity);
                    for (Map.Entry param : params.entrySet()) {
                        String[] values;
                        String name = (String)param.getKey();
                        for (String value : values = (String[])param.getValue()) {
                            NamedString formParameter = WSRPTypeFactory.createNamedString((String)name, (String)value);
                            formParameters.add(formParameter);
                        }
                    }
                    interactionParams.getFormParameters().addAll(formParameters);
                }
            }
        }
        catch (Exception e) {
            log.debug("Couldn't create UploadContext", (Throwable)e);
        }
        if (trace) {
            log.trace(WSRPUtils.toString((InteractionParams)interactionParams));
        }
        return WSRPTypeFactory.createPerformBlockingInteraction((RegistrationContext)requestPrecursor.getRegistrationContext(), (PortletContext)portletContext, (RuntimeContext)requestPrecursor.getRuntimeContext(), (UserContext)requestPrecursor.getUserContext(), (MarkupParams)requestPrecursor.getMarkupParams(), (InteractionParams)interactionParams);
    }

    @Override
    protected PortletInvocationResponse processResponse(BlockingInteractionResponse response, ActionInvocation invocation, InvocationHandler.RequestPrecursor<ActionInvocation> requestPrecursor) throws PortletInvokerException {
        BlockingInteractionResponse blockingInteractionResponse = response;
        String redirectURL = blockingInteractionResponse.getRedirectURL();
        UpdateResponse updateResponse = blockingInteractionResponse.getUpdateResponse();
        if (redirectURL != null && updateResponse != null) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("Producer error: response cannot both redirect and update state."));
        }
        if (redirectURL == null && updateResponse == null) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("Producer error: response must redirect or update state."));
        }
        if (redirectURL != null) {
            return new HTTPRedirectionResponse(redirectURL);
        }
        return this.processUpdateResponse(invocation, requestPrecursor, updateResponse);
    }

    public static class RequestContextWrapper
    implements org.apache.commons.fileupload.RequestContext {
        private RequestContext requestContext;

        public RequestContextWrapper(RequestContext requestContext) {
            this.requestContext = requestContext;
        }

        public String getCharacterEncoding() {
            return this.requestContext.getCharacterEncoding();
        }

        public String getContentType() {
            return this.requestContext.getContentType();
        }

        public int getContentLength() {
            return this.requestContext.getContentLength();
        }

        public InputStream getInputStream() throws IOException {
            return this.requestContext.getInputStream();
        }
    }
}

