/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DefaultOracleConnectionFactory;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class OracleConnectionFactory
extends DefaultOracleConnectionFactory {
    public static int CONNCACHE_MAX_LIMIT = 25;
    public static int CONNCACHE_MIN_LIMIT = 2;
    public static int CONNCACHE_INACTIVITY_TIMEOUT = 3600;
    public static int CONNCACHE_ABADONDED_TIMEOUT = 1800;
    protected final Object ociDataSource;

    public OracleConnectionFactory(String dbDriver, String dbUrl, String dbUserName, String dbPassword, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner, boolean forceQueryHints) throws RepositoryException {
        super(dbDriver, dbUrl, dbUserName, dbPassword, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner, forceQueryHints);
        Object cds = null;
        try {
            Class<?> cdsClass = OracleConnectionFactory.class.getClassLoader().loadClass("oracle.jdbc.pool.OracleDataSource");
            Constructor<?> cdsConstructor = cdsClass.getConstructor(new Class[0]);
            cds = cdsConstructor.newInstance(new Object[0]);
            Properties prop = new Properties();
            prop.setProperty("InitialLimit", String.valueOf(CONNCACHE_MIN_LIMIT));
            prop.setProperty("MinLimit", String.valueOf(CONNCACHE_MIN_LIMIT));
            prop.setProperty("MaxLimit", String.valueOf(CONNCACHE_MAX_LIMIT));
            prop.setProperty("InactivityTimeout", String.valueOf(CONNCACHE_INACTIVITY_TIMEOUT));
            prop.setProperty("AbandonedConnectionTimeout", String.valueOf(CONNCACHE_ABADONDED_TIMEOUT));
            Method setURL = cds.getClass().getMethod("setURL", String.class);
            setURL.invoke(cds, this.dbUrl);
            Method setUser = cds.getClass().getMethod("setUser", String.class);
            setUser.invoke(cds, this.dbUserName);
            Method setPassword = cds.getClass().getMethod("setPassword", String.class);
            setPassword.invoke(cds, this.dbPassword);
            Method setConnectionCachingEnabled = cds.getClass().getMethod("setConnectionCachingEnabled", Boolean.TYPE);
            setConnectionCachingEnabled.invoke(cds, true);
            Method setConnectionCacheProperties = cds.getClass().getMethod("setConnectionCacheProperties", Properties.class);
            setConnectionCacheProperties.invoke(cds, prop);
            Method setConnectionCacheName = cds.getClass().getMethod("setConnectionCacheName", String.class);
            setConnectionCacheName.invoke(cds, "EXOJCR_OCI__" + containerName);
        }
        catch (Throwable e) {
            cds = null;
            String err = "Oracle OCI connection cache is unavailable due to error " + e;
            if (e.getCause() != null) {
                err = err + " (" + e.getCause() + ")";
            }
            err = err + ". Standard JDBC DriverManager will be used for connections opening.";
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)err, e);
            }
            this.log.warn((Object)err);
        }
        this.ociDataSource = cds;
    }

    public Connection getJdbcConnection(boolean readOnly) throws RepositoryException {
        if (this.ociDataSource != null) {
            try {
                Connection conn = this.getCachedConnection();
                if (readOnly) {
                    conn.setReadOnly(true);
                }
                return conn;
            }
            catch (Throwable e) {
                throw new RepositoryException("Oracle OCI cached connection open error " + e, e);
            }
        }
        return super.getJdbcConnection(readOnly);
    }

    protected Connection getCachedConnection() throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getConnection = this.ociDataSource.getClass().getMethod("getConnection", new Class[0]);
        Connection conn = (Connection)getConnection.invoke(this.ociDataSource, new Object[0]);
        return conn;
    }
}

