/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.stack.Interval;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.Util;

public class TimerTest
extends TestCase {
    Timer win = null;
    static final int NUM_MSGS = 1000;
    long[] xmit_timeouts = new long[]{1000L, 2000L, 4000L, 8000L};
    double PERCENTAGE_OFF = 0.3;
    HashMap msgs = new HashMap();

    public TimerTest(String name) {
        super(name);
    }

    public void testRetransmits() {
        Entry entry;
        long i;
        int num_non_correct_entries = 0;
        this.win = new Timer();
        System.out.println("-- adding 1000 messages:");
        for (i = 0L; i < 1000L; ++i) {
            entry = new Entry(i);
            MyTask task = new MyTask(entry);
            this.msgs.put(new Long(i), entry);
            this.win.schedule((TimerTask)task, entry.next());
        }
        System.out.println("-- done");
        System.out.println("-- waiting for 20 secs for all retransmits");
        Util.sleep(20000L);
        for (i = 0L; i < 1000L; ++i) {
            entry = (Entry)this.msgs.get(new Long(i));
            if (entry.isCorrect()) continue;
            ++num_non_correct_entries;
        }
        if (num_non_correct_entries > 0) {
            System.err.println("Number of incorrect retransmission timeouts: " + num_non_correct_entries);
        } else {
            for (i = 0L; i < 1000L; ++i) {
                entry = (Entry)this.msgs.get(new Long(i));
                if (entry == null) continue;
                System.out.println(i + ": " + entry);
            }
        }
        TimerTest.assertSame((Object)0, (Object)num_non_correct_entries);
        try {
            this.win.cancel();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TimerTest.class);
        return suite;
    }

    public static void main(String[] args) {
        String[] name = new String[]{TimerTest.class.getName()};
        TestRunner.main((String[])name);
    }

    class Entry {
        long start_time = 0L;
        long first_xmit = 0L;
        long second_xmit = 0L;
        long third_xmit = 0L;
        long fourth_xmit = 0L;
        Interval interval;
        long seqno;

        Entry(long seqno) {
            this.interval = new StaticInterval(TimerTest.this.xmit_timeouts);
            this.seqno = 0L;
            this.seqno = seqno;
            this.start_time = System.currentTimeMillis();
        }

        public void retransmit() {
            if (this.first_xmit == 0L) {
                this.first_xmit = System.currentTimeMillis();
            } else if (this.second_xmit == 0L) {
                this.second_xmit = System.currentTimeMillis();
            } else if (this.third_xmit == 0L) {
                this.third_xmit = System.currentTimeMillis();
            } else if (this.fourth_xmit == 0L) {
                this.fourth_xmit = System.currentTimeMillis();
            }
            TimerTest.this.win.schedule((TimerTask)new MyTask(this), this.interval.next());
        }

        public long next() {
            return this.interval.next();
        }

        boolean isCorrect() {
            long delta;
            boolean off = false;
            long expected = TimerTest.this.xmit_timeouts[0];
            long t = this.first_xmit - this.start_time;
            long diff = Math.abs(expected - t);
            if (diff >= (delta = (long)((double)expected * TimerTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = TimerTest.this.xmit_timeouts[1]) - (t = this.second_xmit - this.first_xmit))) >= (delta = (long)((double)expected * TimerTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = TimerTest.this.xmit_timeouts[2]) - (t = this.third_xmit - this.second_xmit))) >= (delta = (long)((double)expected * TimerTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = TimerTest.this.xmit_timeouts[3]) - (t = this.fourth_xmit - this.third_xmit))) >= (delta = (long)((double)expected * TimerTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if (off) {
                System.err.println("#" + this.seqno + ": " + this + ": (" + "entry is more than " + TimerTest.this.PERCENTAGE_OFF + " percentage off ");
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.first_xmit - this.start_time).append(", ").append(this.second_xmit - this.first_xmit).append(", ");
            sb.append(this.third_xmit - this.second_xmit).append(", ").append(this.fourth_xmit - this.third_xmit);
            return sb.toString();
        }
    }

    class MyTask
    extends TimerTask {
        Entry entry;

        MyTask(Entry entry) {
            this.entry = entry;
        }

        public void run() {
            this.entry.retransmit();
        }
    }
}

