/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.EntityModeToTuplizerMapping;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.tuple.component.ComponentTuplizerFactory;

class ComponentEntityModeToTuplizerMapping
extends EntityModeToTuplizerMapping
implements Serializable {
    private ComponentTuplizerFactory componentTuplizerFactory = new ComponentTuplizerFactory();

    public ComponentEntityModeToTuplizerMapping(Component component) {
        String tuplizerClassName;
        PersistentClass owner = component.getOwner();
        HashMap userSuppliedTuplizerImpls = new HashMap();
        if (component.getTuplizerMap() != null) {
            userSuppliedTuplizerImpls.putAll(component.getTuplizerMap());
        }
        ComponentTuplizer dynamicMapTuplizer = (tuplizerClassName = (String)userSuppliedTuplizerImpls.remove(EntityMode.MAP)) == null ? this.componentTuplizerFactory.constructDefaultTuplizer(EntityMode.MAP, component) : this.componentTuplizerFactory.constructTuplizer(tuplizerClassName, component);
        tuplizerClassName = (String)userSuppliedTuplizerImpls.remove(EntityMode.POJO);
        ComponentTuplizer pojoTuplizer = owner.hasPojoRepresentation() && component.hasPojoRepresentation() ? (tuplizerClassName == null ? this.componentTuplizerFactory.constructDefaultTuplizer(EntityMode.POJO, component) : this.componentTuplizerFactory.constructTuplizer(tuplizerClassName, component)) : dynamicMapTuplizer;
        tuplizerClassName = (String)userSuppliedTuplizerImpls.remove(EntityMode.DOM4J);
        ComponentTuplizer dom4jTuplizer = owner.hasDom4jRepresentation() ? (tuplizerClassName == null ? this.componentTuplizerFactory.constructDefaultTuplizer(EntityMode.DOM4J, component) : this.componentTuplizerFactory.constructTuplizer(tuplizerClassName, component)) : null;
        if (pojoTuplizer != null) {
            this.addTuplizer(EntityMode.POJO, pojoTuplizer);
        }
        if (dynamicMapTuplizer != null) {
            this.addTuplizer(EntityMode.MAP, dynamicMapTuplizer);
        }
        if (dom4jTuplizer != null) {
            this.addTuplizer(EntityMode.DOM4J, dom4jTuplizer);
        }
        if (!userSuppliedTuplizerImpls.isEmpty()) {
            Iterator itr = userSuppliedTuplizerImpls.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                EntityMode entityMode = (EntityMode)entry.getKey();
                String userTuplizerClassName = (String)entry.getValue();
                ComponentTuplizer tuplizer = this.componentTuplizerFactory.constructTuplizer(userTuplizerClassName, component);
                this.addTuplizer(entityMode, tuplizer);
            }
        }
    }
}

