/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.io.IOTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDumperFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(RequestDumperFilter.class);

    public void init(FilterConfig cfg) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)req, (HttpServletResponse)resp, chain);
    }

    public void doFilter(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            StringBuffer tmp = new StringBuffer();
            tmp.append("characterEncoding=").append(req.getCharacterEncoding()).append('\n');
            tmp.append("contentLength=").append(req.getContentLength()).append('\n');
            tmp.append("contentType=").append(req.getContentType()).append('\n');
            tmp.append("method=").append(req.getMethod()).append('\n');
            tmp.append("pathInfo=").append(req.getPathInfo()).append('\n');
            tmp.append("queryString=").append(req.getQueryString()).append('\n');
            tmp.append("requestURI=").append(req.getRequestURI()).append('\n');
            tmp.append("servletPath=").append(req.getServletPath()).append('\n');
            Iterator i$ = req.getParameterMap().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                String name = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                tmp.append("param.").append(name).append('=');
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j];
                    tmp.append(j == 0 ? "" : ",").append(value);
                }
            }
            BufferedReader reader = req.getReader();
            if (reader != null) {
                StringWriter buffer = new StringWriter();
                IOTools.copy((Reader)reader, (Writer)buffer);
                tmp.append("body=").append(buffer.toString());
            }
            log.trace(tmp.toString());
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public void destroy() {
    }
}

