/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.policies;

import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.InvalidConsumerDataException;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.wsrp.registration.PropertyDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationPolicyWrapper
implements RegistrationPolicy {
    private final RegistrationPolicy delegate;

    public RegistrationPolicyWrapper(RegistrationPolicy delegate) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)delegate, (String)"Delegate");
        this.delegate = delegate;
    }

    public RegistrationPolicy getDelegate() {
        return this.delegate;
    }

    @Override
    public void validateRegistrationDataFor(Map<QName, Object> registrationProperties, String consumerIdentity) throws IllegalArgumentException, RegistrationException {
        this.delegate.validateRegistrationDataFor(registrationProperties, consumerIdentity);
    }

    @Override
    public String createRegistrationHandleFor(String registrationId) throws IllegalArgumentException {
        return this.delegate.createRegistrationHandleFor(registrationId);
    }

    @Override
    public String getAutomaticGroupNameFor(String consumerName) throws IllegalArgumentException {
        return this.delegate.getAutomaticGroupNameFor(consumerName);
    }

    @Override
    public String getConsumerIdFrom(String consumerName, Map<QName, Object> registrationProperties) throws IllegalArgumentException, InvalidConsumerDataException {
        return this.delegate.getConsumerIdFrom(RegistrationPolicyWrapper.sanitizeConsumerName(consumerName), registrationProperties);
    }

    @Override
    public void validateConsumerName(String consumerName) throws IllegalArgumentException, RegistrationException {
        this.delegate.validateConsumerName(consumerName);
    }

    @Override
    public void validateConsumerGroupName(String groupName) throws IllegalArgumentException, RegistrationException {
        this.delegate.validateConsumerGroupName(groupName);
    }

    @Override
    public RegistrationManager getManager() {
        return this.delegate.getManager();
    }

    @Override
    public void setManager(RegistrationManager manager) {
        this.delegate.setManager(manager);
    }

    @Override
    public void setExpectations(Map<QName, ? extends PropertyDescription> registrationPropertyDescriptions) {
        this.delegate.setExpectations(registrationPropertyDescriptions);
    }

    static String sanitizeConsumerName(String consumerName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        consumerName = consumerName.trim();
        consumerName = consumerName.replaceAll(",", "_");
        consumerName = consumerName.replaceAll(" ", "_");
        consumerName = consumerName.replaceAll("/", "_");
        return consumerName;
    }
}

