/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mc.common;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalUtils {
    private static ThreadLocal<Kernel> tlKernel = new ThreadLocal();
    private static ThreadLocal<DeploymentUnit> tlDU = new ThreadLocal();

    public static void putKernel(Kernel kernel) {
        tlKernel.set(kernel);
    }

    public static Kernel getKernel() {
        return tlKernel.get();
    }

    public static void removeKernel() {
        tlKernel.remove();
    }

    public static KernelController getController() {
        Kernel kernel = ThreadLocalUtils.getKernel();
        return kernel != null ? kernel.getController() : null;
    }

    public static void putUnit(DeploymentUnit unit) {
        tlDU.set(unit);
    }

    public static DeploymentUnit getUnit() {
        return tlDU.get();
    }

    public static void removeUnit() {
        tlDU.remove();
    }

    public static <T> T getAttachment(Class<T> attachmentClass) {
        DeploymentUnit unit = ThreadLocalUtils.getUnit();
        return (T)(unit != null ? unit.getAttachment(attachmentClass) : null);
    }

    public static Object getAttachment(String attachmentName) {
        DeploymentUnit unit = ThreadLocalUtils.getUnit();
        return unit != null ? unit.getAttachment(attachmentName) : null;
    }

    public static <T> T getAttachment(String attachmentName, Class<T> attachmentClass) {
        DeploymentUnit unit = ThreadLocalUtils.getUnit();
        return (T)(unit != null ? unit.getAttachment(attachmentName, attachmentClass) : null);
    }
}

