/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MERGE2
extends Protocol {
    private Address local_addr = null;
    private final FindSubgroupsTask task = new FindSubgroupsTask();
    private long min_interval = 5000L;
    private long max_interval = 20000L;
    private volatile boolean is_coord = false;
    private volatile boolean use_separate_thread = false;
    private TimeScheduler timer;

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
    }

    @Override
    public String getName() {
        return "MERGE2";
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    public void setMinInterval(long i) {
        this.min_interval = i;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    public void setMaxInterval(long l) {
        this.max_interval = l;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("min_interval");
        if (str != null) {
            this.min_interval = Long.parseLong(str);
            props.remove("min_interval");
        }
        if ((str = props.getProperty("max_interval")) != null) {
            this.max_interval = Long.parseLong(str);
            props.remove("max_interval");
        }
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"min_interval and max_interval have to be > 0");
            }
            return false;
        }
        if (this.max_interval <= this.min_interval) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"max_interval has to be greater than min_interval");
            }
            return false;
        }
        str = props.getProperty("use_separate_thread");
        if (str != null) {
            this.use_separate_thread = Boolean.valueOf(str);
            props.remove("use_separate_thread");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(1);
        retval.addElement(new Integer(12));
        return retval;
    }

    @Override
    public void stop() {
        this.is_coord = false;
        this.task.stop();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                return this.up_prot.up(evt);
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                Object ret = this.down_prot.down(evt);
                Vector<Address> mbrs = ((View)evt.getArg()).getMembers();
                if (mbrs == null || mbrs.isEmpty() || this.local_addr == null) {
                    this.task.stop();
                    return ret;
                }
                Address coord = mbrs.elementAt(0);
                if (coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.task.start();
                } else {
                    if (this.is_coord) {
                        this.is_coord = false;
                    }
                    this.task.stop();
                }
                return ret;
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindSubgroupsTask {
        private Future<?> future;

        private FindSubgroupsTask() {
        }

        public synchronized void start() {
            if (this.future == null || this.future.isDone()) {
                this.future = MERGE2.this.timer.scheduleWithFixedDelay(new Runnable(){

                    public void run() {
                        FindSubgroupsTask.this.findAndNotify();
                    }
                }, Math.max(this.computeInterval(), 5000L), this.computeInterval(), TimeUnit.MILLISECONDS);
            }
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }

        public void findAndNotify() {
            List<PingRsp> initial_mbrs = this.findInitialMembers();
            Vector<Address> coords = this.detectMultipleCoordinators(initial_mbrs);
            if (coords.size() > 1) {
                if (MERGE2.this.log.isDebugEnabled()) {
                    MERGE2.this.log.debug((Object)(MERGE2.this.local_addr + " found multiple coordinators: " + coords + "; sending up MERGE event"));
                }
                final Event evt = new Event(14, coords);
                if (MERGE2.this.use_separate_thread) {
                    Thread merge_notifier = new Thread(){

                        public void run() {
                            MERGE2.this.up_prot.up(evt);
                        }
                    };
                    merge_notifier.setDaemon(true);
                    merge_notifier.setName("merge notifier thread");
                    merge_notifier.start();
                } else {
                    MERGE2.this.up_prot.up(evt);
                }
            }
            if (MERGE2.this.log.isTraceEnabled()) {
                MERGE2.this.log.trace((Object)("MERGE2.FindSubgroups thread terminated (local_addr=" + MERGE2.this.local_addr + ")"));
            }
        }

        long computeInterval() {
            return MERGE2.this.min_interval + Util.random(MERGE2.this.max_interval - MERGE2.this.min_interval);
        }

        List<PingRsp> findInitialMembers() {
            PingRsp tmp = new PingRsp(MERGE2.this.local_addr, MERGE2.this.local_addr, true);
            List retval = (List)MERGE2.this.down_prot.down(new Event(12));
            if (retval != null && MERGE2.this.is_coord && MERGE2.this.local_addr != null && !retval.contains(tmp)) {
                retval.add(tmp);
            }
            return retval;
        }

        Vector<Address> detectMultipleCoordinators(List<PingRsp> initial_mbrs) {
            Vector<Address> ret = new Vector<Address>(11);
            if (initial_mbrs != null) {
                for (PingRsp response : initial_mbrs) {
                    Address coord;
                    if (!response.isServer() || ret.contains(coord = response.getCoordAddress())) continue;
                    ret.add(coord);
                }
            }
            return ret;
        }
    }
}

