/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.ConsumerCapabilities;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.RegistrationUtils;
import org.gatein.registration.impl.ConsumerCapabilitiesImpl;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerImpl
implements ConsumerSPI {
    private String name;
    private String identity;
    private String consumerAgent;
    private Set<Registration> registrations;
    private ConsumerGroup group;
    private ConsumerCapabilities capabilities;
    private String key;

    private ConsumerImpl() {
        this.init();
    }

    ConsumerImpl(String identity, String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"name", (String)"Consumer");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)identity, (String)"identity", (String)"Consumer");
        this.name = name;
        this.identity = identity;
        this.init();
    }

    private void init() {
        this.registrations = new HashSet<Registration>(7);
        this.capabilities = new ConsumerCapabilitiesImpl();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerImpl consumer = (ConsumerImpl)o;
        return this.identity.equals(consumer.identity);
    }

    public int hashCode() {
        return this.identity.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.identity;
    }

    @Override
    public String getConsumerAgent() {
        return this.consumerAgent;
    }

    @Override
    public void setConsumerAgent(String consumerAgent) throws IllegalArgumentException, IllegalStateException {
        if (consumerAgent != null && !consumerAgent.equals(this.consumerAgent)) {
            RegistrationUtils.validateConsumerAgent(consumerAgent);
            this.consumerAgent = consumerAgent;
        }
    }

    @Override
    public String getPersistentKey() {
        return this.key;
    }

    @Override
    public ConsumerCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void setCapabilities(ConsumerCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public RegistrationStatus getStatus() {
        if (ParameterValidation.existsAndIsNotEmpty(this.registrations)) {
            RegistrationStatus result = RegistrationStatus.VALID;
            for (Registration registration : this.registrations) {
                RegistrationStatus status = registration.getStatus();
                if (RegistrationStatus.INVALID == status) {
                    return RegistrationStatus.INVALID;
                }
                if (RegistrationStatus.PENDING != status) continue;
                result = status;
            }
            return result;
        }
        return RegistrationStatus.PENDING;
    }

    @Override
    public Collection<Registration> getRegistrations() throws RegistrationException {
        return Collections.unmodifiableSet(this.registrations);
    }

    @Override
    public ConsumerGroup getGroup() {
        return this.group;
    }

    @Override
    public void addRegistration(RegistrationSPI registration) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registration, (String)"Registration");
        this.registrations.add(registration);
    }

    @Override
    public void setPersistentKey(String key) {
        this.key = key;
    }

    @Override
    public void removeRegistration(RegistrationSPI registration) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registration, (String)"Registration");
        this.registrations.remove(registration);
    }

    @Override
    public void setGroup(ConsumerGroup group) throws RegistrationException {
        if (this.group != null) {
            if (this.group.equals(group)) {
                return;
            }
            if (this.group.contains(this)) {
                this.group.removeConsumer(this);
            }
        }
        this.group = group;
        if (group != null && !this.group.contains(this)) {
            group.addConsumer(this);
        }
    }
}

