/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LockData
implements Externalizable {
    private long birthday;
    private boolean deep;
    private String tokenHash;
    private String nodeIdentifier;
    private String owner;
    private boolean sessionScoped;
    private long timeOut;

    public LockData() {
        this.sessionScoped = false;
        this.deep = false;
    }

    public LockData(String nodeIdentifier, String lockTokenHash, boolean deep, boolean sessionScoped, String owner, long timeOut) {
        this(nodeIdentifier, lockTokenHash, deep, sessionScoped, owner, timeOut, System.currentTimeMillis());
    }

    public LockData(String nodeIdentifier, String lockTokenHash, boolean deep, boolean sessionScoped, String owner, long timeOut, long birthday) {
        this.nodeIdentifier = nodeIdentifier;
        this.tokenHash = lockTokenHash;
        this.deep = deep;
        this.sessionScoped = sessionScoped;
        this.owner = owner;
        this.timeOut = timeOut;
        this.birthday = birthday;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof LockData) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getTimeToDeath() {
        return this.birthday + this.timeOut - System.currentTimeMillis();
    }

    public String getTokenHash() {
        return this.tokenHash;
    }

    public int hashCode() {
        return this.tokenHash.hashCode();
    }

    public boolean isDeep() {
        return this.deep;
    }

    public boolean isSessionScoped() {
        return this.sessionScoped;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deep = in.readBoolean();
        this.sessionScoped = in.readBoolean();
        this.birthday = in.readLong();
        this.timeOut = in.readLong();
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.nodeIdentifier = new String(buf, "UTF-8");
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.owner = new String(buf, "UTF-8");
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.tokenHash = new String(buf, "UTF-8");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.deep);
        out.writeBoolean(this.sessionScoped);
        out.writeLong(this.birthday);
        out.writeLong(this.timeOut);
        byte[] ptbuf = this.nodeIdentifier.getBytes("UTF-8");
        out.writeInt(ptbuf.length);
        out.write(ptbuf);
        ptbuf = this.owner.getBytes("UTF-8");
        out.writeInt(ptbuf.length);
        out.write(ptbuf);
        ptbuf = this.tokenHash.getBytes("UTF-8");
        out.writeInt(ptbuf.length);
        out.write(ptbuf);
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public long getBirthDay() {
        return this.birthday;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }
}

