/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache.jdbc;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.transaction.TransactionManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.lock.LockRemover;
import org.exoplatform.services.jcr.impl.core.lock.LockRemoverHolder;
import org.exoplatform.services.jcr.impl.core.lock.SessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.CacheableLockManager;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.CacheableSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.LockData;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.jdbc.LockJDBCConnection;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.jdbc.LockJDBCContainer;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.transaction.TransactionService;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="lockmanager")})
public class CacheableJDBCLockManagerImpl
implements CacheableLockManager,
ItemsPersistenceListener,
Startable {
    public static final String TIME_OUT = "time-out";
    public static final String JBOSSCACCHE_CONFIG = "jbosscache-configuration";
    public static final String DATA_SOURCE = "datasource";
    public static final long DEFAULT_LOCK_TIMEOUT = 1800000L;
    public static final String LOCKS = "$LOCKS";
    public static final String LOCK_DATA = "$LOCK_DATA";
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.CacheableJDBCLockManagerImpl");
    private final DataManager dataManager;
    private long lockTimeOut;
    private LockRemover lockRemover;
    private Cache<Serializable, Object> cache;
    private LockJDBCContainer lockJDBCContainer;
    private final Fqn<String> lockRoot = Fqn.fromElements((Object[])new String[]{"$LOCKS"});
    private Map<String, CacheableSessionLockManager> sessionLockManagers;

    public CacheableJDBCLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionService transactionService, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, transactionService.getTransactionManager(), cfm, lockRemoverHolder);
    }

    public CacheableJDBCLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, (TransactionManager)null, cfm, lockRemoverHolder);
    }

    public CacheableJDBCLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionManager transactionManager, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        long timeOut;
        List<SimpleParameterEntry> paramenerts = config.getLockManager().getParameters();
        this.dataManager = dataManager;
        this.lockTimeOut = config.getLockManager() != null ? (paramenerts != null && config.getLockManager().getParameterValue(TIME_OUT, null) != null ? ((timeOut = config.getLockManager().getParameterTime(TIME_OUT).longValue()) > 0L ? timeOut : 1800000L) : (config.getLockManager().getTimeout() > 0L ? config.getLockManager().getTimeout() : 1800000L)) : 1800000L;
        this.sessionLockManagers = new HashMap<String, CacheableSessionLockManager>();
        dataManager.addItemPersistenceListener(this);
        if (config.getLockManager() == null) {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        String dataSourceName = config.getLockManager().getParameterValue(DATA_SOURCE);
        this.lockJDBCContainer = new LockJDBCContainer(dataSourceName, config.getName());
        ExoJBossCacheFactory factory = new ExoJBossCacheFactory(cfm, transactionManager);
        this.cache = factory.createCache(config.getLockManager());
        this.cache.create();
        this.cache.start();
        this.createStructuredNode(this.lockRoot);
        context.recall();
        this.lockRemover = lockRemoverHolder.getLockRemover(this);
    }

    @Managed
    @ManagedDescription(value="Remove the expired locks")
    public void cleanExpiredLocks() {
        this.removeExpired();
    }

    @Override
    public long getDefaultLockTimeOut() {
        return this.lockTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Managed
    @ManagedDescription(value="The number of active locks")
    public int getNumLocks() {
        int lockNum = -1;
        LockJDBCConnection connection = null;
        connection = this.lockJDBCContainer.openConnection();
        lockNum = connection.getLockedNodes().size();
        Object var5_3 = null;
        if (connection == null) return lockNum;
        try {
            connection.close();
            return lockNum;
        }
        catch (IllegalStateException e) {
            return lockNum;
        }
        catch (RepositoryException e) {}
        return lockNum;
        {
            catch (RepositoryException repositoryException) {
                Object var5_4 = null;
                if (connection == null) return lockNum;
                try {
                    connection.close();
                    return lockNum;
                }
                catch (IllegalStateException e) {
                    return lockNum;
                }
                catch (RepositoryException e) {}
                return lockNum;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw throwable;
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Override
    public SessionLockManager getSessionLockManager(String sessionId, SessionDataManager transientManager) {
        CacheableSessionLockManager sessionManager = new CacheableSessionLockManager(sessionId, this, transientManager);
        this.sessionLockManagers.put(sessionId, sessionManager);
        return sessionManager;
    }

    @Override
    public boolean isLockLive(String nodeId) throws LockException {
        try {
            return this.lockExist(nodeId);
        }
        catch (RepositoryException e) {
            throw new LockException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    @Override
    public void onSaveItems(ItemStateChangesLog changesLog) {
        ArrayList<PlainChangesLog> chengesLogList = new ArrayList<PlainChangesLog>();
        if (changesLog instanceof TransactionChangesLog) {
            ChangesLogIterator logIterator = ((TransactionChangesLog)changesLog).getLogIterator();
            while (logIterator.hasNextLog()) {
                chengesLogList.add(logIterator.nextLog());
            }
        } else if (changesLog instanceof PlainChangesLog) {
            chengesLogList.add((PlainChangesLog)changesLog);
        } else if (changesLog instanceof CompositeChangesLog) {
            ChangesLogIterator iter = ((CompositeChangesLog)changesLog).getLogIterator();
            while (iter.hasNextLog()) {
                chengesLogList.add(iter.nextLog());
            }
        }
        ArrayList<LockOperationContainer> containers = new ArrayList<LockOperationContainer>();
        block11: for (PlainChangesLog currChangesLog : chengesLogList) {
            String sessionId = currChangesLog.getSessionId();
            try {
                switch (currChangesLog.getEventType()) {
                    case 0x400000: {
                        if (currChangesLog.getSize() < 2) {
                            this.log.error((Object)("Incorrect changes log  of type ExtendedEvent.LOCK size=" + currChangesLog.getSize() + "<2 \n" + currChangesLog.dump()));
                            break;
                        }
                        String nodeIdentifier = currChangesLog.getAllStates().get(0).getData().getParentIdentifier();
                        CacheableSessionLockManager session = this.sessionLockManagers.get(sessionId);
                        if (session != null && session.containsPendingLock(nodeIdentifier)) {
                            containers.add(new LockOperationContainer(nodeIdentifier, currChangesLog.getSessionId(), 0x400000));
                            break;
                        }
                        this.log.error((Object)"Lock must exist in pending locks.");
                        break;
                    }
                    case 0x800000: {
                        if (currChangesLog.getSize() < 2) {
                            this.log.error((Object)("Incorrect changes log  of type ExtendedEvent.UNLOCK size=" + currChangesLog.getSize() + "<2 \n" + currChangesLog.dump()));
                            break;
                        }
                        containers.add(new LockOperationContainer(currChangesLog.getAllStates().get(0).getData().getParentIdentifier(), currChangesLog.getSessionId(), 0x800000));
                        break;
                    }
                    default: {
                        String nodeIdentifier;
                        HashSet<String> removedLock = new HashSet<String>();
                        for (ItemState itemState : currChangesLog.getAllStates()) {
                            if (!itemState.getData().isNode() || !this.lockExist(itemState.getData().getIdentifier())) continue;
                            nodeIdentifier = itemState.getData().getIdentifier();
                            if (itemState.isDeleted()) {
                                removedLock.add(nodeIdentifier);
                                continue;
                            }
                            if (!itemState.isAdded() && !itemState.isRenamed() && !itemState.isUpdated()) continue;
                            removedLock.remove(nodeIdentifier);
                        }
                        for (String identifier : removedLock) {
                            containers.add(new LockOperationContainer(identifier, currChangesLog.getSessionId(), 0x800000));
                        }
                        continue block11;
                    }
                }
            }
            catch (IllegalStateException e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Collections.sort(containers);
        for (LockOperationContainer container : containers) {
            try {
                container.apply();
            }
            catch (LockException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void refreshLockData(LockData newLockData) throws LockException {
        LockJDBCConnection connection = null;
        connection = this.lockJDBCContainer.openConnection();
        connection.refreshLockData(newLockData);
        connection.commit();
        Fqn<String> fqn = this.makeLockFqn(newLockData.getNodeIdentifier());
        this.cache.put(fqn, (Object)LOCK_DATA, (Object)newLockData);
        Object var5_5 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (IllegalStateException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        catch (RepositoryException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return;
        {
            catch (RepositoryException e) {
                throw new LockException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (IllegalStateException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw throwable;
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void removeExpired() {
        ArrayList<String> removeLockList = new ArrayList<String>();
        try {
            List<LockData> lockDatas = this.getLockList();
            for (LockData lock : lockDatas) {
                if (lock.isSessionScoped() || lock.getTimeToDeath() >= 0L) continue;
                removeLockList.add(lock.getNodeIdentifier());
            }
            Collections.sort(removeLockList);
            for (String rLock : removeLockList) {
                this.removeLock(rLock);
            }
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Exception removing expired locks", (Throwable)e);
        }
    }

    public void start() {
        this.lockRemover.start();
    }

    public void stop() {
        this.lockRemover.stop();
        this.sessionLockManagers.clear();
        this.cache.stop();
    }

    private TransientItemData copyItemData(PropertyData prop) throws RepositoryException {
        if (prop == null) {
            return null;
        }
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued(), prop.getValues());
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void internalLock(String sessionId, String nodeIdentifier) throws RepositoryException {
        CacheableSessionLockManager sessionLockManager = this.sessionLockManagers.get(sessionId);
        if (sessionLockManager == null || !sessionLockManager.containsPendingLock(nodeIdentifier)) throw new LockException("No lock in pending locks");
        LockData lockData = sessionLockManager.getPendingLock(nodeIdentifier);
        LockJDBCConnection connection = null;
        try {
            connection = this.lockJDBCContainer.openConnection();
            connection.addLockData(lockData);
            connection.commit();
            Fqn<String> lockPath = this.makeLockFqn(lockData.getNodeIdentifier());
            this.cache.put(lockPath, (Object)LOCK_DATA, (Object)lockData);
            sessionLockManager.notifyLockPersisted(nodeIdentifier);
            Object var8_7 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (IllegalStateException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw throwable;
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
        try {
            connection.close();
            return;
        }
        catch (IllegalStateException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        catch (RepositoryException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void internalUnLock(String sessionId, String nodeIdentifier) throws RepositoryException {
        LockJDBCConnection connection;
        block9: {
            LockData lData = this.getLockDataById(nodeIdentifier);
            if (lData == null) return;
            connection = null;
            connection = this.lockJDBCContainer.openConnection();
            connection.removeLockData(nodeIdentifier);
            connection.commit();
            this.cache.removeNode(this.makeLockFqn(nodeIdentifier));
            CacheableSessionLockManager sessMgr = this.sessionLockManagers.get(sessionId);
            if (sessMgr == null) break block9;
            sessMgr.notifyLockRemoved(nodeIdentifier);
        }
        Object var7_7 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (IllegalStateException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        catch (RepositoryException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return;
        {
            catch (RepositoryException e) {
                throw new LockException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (IllegalStateException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw throwable;
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockExist(String nodeId) throws RepositoryException {
        boolean bl;
        block8: {
            if (this.cache.get(this.makeLockFqn(nodeId), (Object)LOCK_DATA) != null) {
                return true;
            }
            LockJDBCConnection connection = null;
            try {
                connection = this.lockJDBCContainer.openConnection();
                bl = connection.isLockDataExist(nodeId);
                Object var5_4 = null;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var5_5 = null;
                    if (connection == null) break block9;
                    try {
                        connection.close();
                    }
                    catch (IllegalStateException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (IllegalStateException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return bl;
    }

    @Override
    public String getLockTokenHash(String token) {
        String hash = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(token.getBytes(), 0, token.length());
            hash = new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)"Can't get instanse of MD5 MessageDigest!", (Throwable)e);
        }
        return hash;
    }

    @Override
    public LockData getExactNodeOrCloseParentLock(NodeData node) throws RepositoryException {
        NodeData parentData;
        if (node == null) {
            return null;
        }
        LockData retval = null;
        retval = this.getLockDataById(node.getIdentifier());
        if (retval == null && (parentData = (NodeData)this.dataManager.getItemData(node.getParentIdentifier())) != null) {
            retval = this.getExactNodeOrCloseParentLock(parentData);
        }
        return retval;
    }

    @Override
    public LockData getClosedChild(NodeData node) throws RepositoryException {
        LockData retval = null;
        List<NodeData> childData = this.dataManager.getChildNodesData(node);
        for (NodeData nodeData : childData) {
            retval = this.getLockDataById(nodeData.getIdentifier());
            if (retval == null) continue;
            return retval;
        }
        for (NodeData nodeData : childData) {
            retval = this.getClosedChild(nodeData);
            if (retval == null) continue;
            return retval;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LockData getLockDataById(String nodeId) throws RepositoryException {
        LockData lockData;
        block8: {
            LockData lData = (LockData)this.cache.get(this.makeLockFqn(nodeId), (Object)LOCK_DATA);
            if (lData != null) {
                return lData;
            }
            LockJDBCConnection connection = null;
            try {
                connection = this.lockJDBCContainer.openConnection();
                lockData = connection.getLockData(nodeId);
                Object var6_5 = null;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_6 = null;
                    if (connection == null) break block9;
                    try {
                        connection.close();
                    }
                    catch (IllegalStateException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (IllegalStateException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return lockData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<LockData> getLockList() throws RepositoryException {
        ArrayList<LockData> arrayList;
        block9: {
            LockJDBCConnection connection = null;
            try {
                connection = this.lockJDBCContainer.openConnection();
                Set<String> nodesId = connection.getLockedNodes();
                ArrayList<LockData> locksData = new ArrayList<LockData>();
                for (String nodeId : nodesId) {
                    LockData lockData = (LockData)this.cache.get(this.makeLockFqn(nodeId), (Object)LOCK_DATA);
                    if (lockData != null) {
                        locksData.add(lockData);
                        continue;
                    }
                    locksData.add(connection.getLockData(nodeId));
                }
                arrayList = locksData;
                Object var8_7 = null;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_8 = null;
                    if (connection == null) break block10;
                    try {
                        connection.close();
                    }
                    catch (IllegalStateException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (IllegalStateException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return arrayList;
    }

    protected void removeLock(String nodeIdentifier) {
        try {
            NodeData nData = (NodeData)this.dataManager.getItemData(nodeIdentifier);
            if (nData == null) {
                return;
            }
            PlainChangesLogImpl changesLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), SystemIdentity.SYSTEM, 0x800000);
            TransientItemData lockOwner = this.copyItemData((PropertyData)this.dataManager.getItemData(nData, new QPathEntry(Constants.JCR_LOCKOWNER, 1), ItemType.PROPERTY));
            if (lockOwner == null) {
                return;
            }
            changesLog.add(ItemState.createDeletedState(lockOwner));
            TransientItemData lockIsDeep = this.copyItemData((PropertyData)this.dataManager.getItemData(nData, new QPathEntry(Constants.JCR_LOCKISDEEP, 1), ItemType.PROPERTY));
            if (lockIsDeep == null) {
                return;
            }
            changesLog.add(ItemState.createDeletedState(lockIsDeep));
            if (lockOwner == null && lockIsDeep == null) {
                return;
            }
            this.dataManager.save(new TransactionChangesLog(changesLog));
        }
        catch (JCRInvalidItemStateException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"The propperty was removed in other node of cluster.", (Throwable)((Object)e));
            }
        }
        catch (RepositoryException e) {
            this.log.error((Object)("Error occur during removing lock" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void closeSessionLockManager(String sessionID) {
        this.sessionLockManagers.remove(sessionID);
    }

    private Fqn<String> makeLockFqn(String nodeId) {
        return Fqn.fromRelativeElements(this.lockRoot, (Object[])new String[]{nodeId});
    }

    private void createStructuredNode(Fqn<String> fqn) {
        Node node = this.cache.getRoot().getChild(fqn);
        if (node == null) {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            node = this.cache.getRoot().addChild(fqn);
        }
        node.setResident(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LockOperationContainer
    implements Comparable<LockOperationContainer> {
        private String identifier;
        private String sessionId;
        private int type;

        public LockOperationContainer(String identifier, String sessionId, int type) {
            this.identifier = identifier;
            this.sessionId = sessionId;
            this.type = type;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void apply() throws LockException {
            try {
                if (this.type == 0x400000) {
                    CacheableJDBCLockManagerImpl.this.internalLock(this.sessionId, this.identifier);
                } else if (this.type == 0x800000) {
                    CacheableJDBCLockManagerImpl.this.internalUnLock(this.sessionId, this.identifier);
                }
            }
            catch (RepositoryException e) {
                throw new LockException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public int compareTo(LockOperationContainer o) {
            return this.identifier.compareTo(o.getIdentifier());
        }
    }
}

