/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCopyVisitor;

public class WorkspaceItemDataCopyVisitor
extends ItemDataCopyVisitor {
    private SessionDataManager srcDataManager;

    public WorkspaceItemDataCopyVisitor(NodeData parent, InternalQName destNodeName, NodeTypeDataManager nodeTypeManager, SessionDataManager srcDataManager, SessionDataManager destDataManager, boolean keepIdentifiers) {
        super(parent, destNodeName, nodeTypeManager, destDataManager, keepIdentifiers);
        this.srcDataManager = srcDataManager;
    }

    public void visit(NodeData node) throws RepositoryException {
        try {
            this.entering(node, this.currentLevel);
            if (this.maxLevel == -1 || this.currentLevel < this.maxLevel) {
                ++this.currentLevel;
                for (PropertyData propertyData : this.srcDataManager.getChildPropertiesData(node)) {
                    propertyData.accept(this);
                }
                for (NodeData nodeData : this.srcDataManager.getChildNodesData(node)) {
                    nodeData.accept(this);
                }
                --this.currentLevel;
            }
            this.leaving(node, this.currentLevel);
        }
        catch (RepositoryException re) {
            this.currentLevel = 0;
            throw re;
        }
    }
}

