/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.util.ResourceLoader;

public class PropertiesModule
extends AbstractModule {
    private static final String DEFAULT_PROPERTIES = "shindig.properties";
    private final Properties properties;

    public PropertiesModule() {
        this.properties = this.readPropertyFile(PropertiesModule.getDefaultPropertiesPath());
    }

    public PropertiesModule(String propertyFile) {
        this.properties = this.readPropertyFile(propertyFile);
    }

    public PropertiesModule(Properties properties) {
        this.properties = properties;
    }

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.getProperties());
    }

    protected static String getDefaultPropertiesPath() {
        return DEFAULT_PROPERTIES;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    private Properties readPropertyFile(String propertyFile) {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = ResourceLoader.openResource(propertyFile);
            properties.load(is);
        }
        catch (IOException e) {
            throw new CreationException(Arrays.asList(new Message("Unable to load properties: " + propertyFile)));
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return properties;
    }
}

