/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.IdentityResourceBundle;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.PropertiesClassLoader;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleLoader;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.BaseResourceBundlePlugin;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseResourceBundleService
implements ResourceBundleService,
Startable {
    protected Log log_;
    protected volatile List<String> classpathResources_;
    protected volatile String[] portalResourceBundleNames_;
    protected LocaleConfigService localeService_;
    protected ExoCache<String, ResourceBundle> cache_;
    private volatile FutureCache<String, ResourceBundle, ResourceBundleContext> futureCache_;
    private final Loader<String, ResourceBundle, ResourceBundleContext> loader_ = new Loader<String, ResourceBundle, ResourceBundleContext>(){

        public ResourceBundle retrieve(ResourceBundleContext context, String key) throws Exception {
            return context.get(key);
        }
    };
    private volatile List<String> initResources_;

    protected void initParams(InitParams params) {
        this.classpathResources_ = params.getValuesParam("classpath.resources").getValues();
        ArrayList prnames = params.getValuesParam("portal.resource.names").getValues();
        this.portalResourceBundleNames_ = new String[prnames.size()];
        for (int i = 0; i < prnames.size(); ++i) {
            this.portalResourceBundleNames_[i] = (String)prnames.get(i);
        }
        this.initResources_ = params.getValuesParam("init.resources").getValues();
    }

    public synchronized void addResourceBundle(BaseResourceBundlePlugin plugin) {
        List<String> initResources;
        List<String> portalResources;
        List<String> classpathResources = plugin.getClasspathResources();
        if (classpathResources != null && !classpathResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(classpathResources);
            if (this.classpathResources_ != null) {
                result.addAll(this.classpathResources_);
            }
            this.classpathResources_ = Collections.unmodifiableList(result);
        }
        if ((portalResources = plugin.getPortalResources()) != null && !portalResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(portalResources);
            if (this.portalResourceBundleNames_ != null) {
                result.addAll(Arrays.asList(this.portalResourceBundleNames_));
            }
            this.portalResourceBundleNames_ = result.toArray(new String[result.size()]);
        }
        if ((initResources = plugin.getInitResources()) != null && !initResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(initResources);
            if (this.initResources_ != null) {
                result.addAll(this.initResources_);
            }
            this.initResources_ = Collections.unmodifiableList(result);
        }
    }

    public void start() {
        PageList<ResourceBundleData> pl = null;
        try {
            pl = this.findResourceDescriptions(new Query(null, null));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot check if a resource already exists", e);
        }
        if (pl.getAvailable() > 0) {
            return;
        }
        List<String> initResources = this.initResources_;
        for (String resource : initResources) {
            this.initResources(resource, Thread.currentThread().getContextClassLoader());
        }
    }

    public void stop() {
    }

    @Override
    public ResourceBundle getResourceBundle(String[] name, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getResourceBundle(name, locale, cl);
    }

    @Override
    public ResourceBundle getResourceBundle(String name, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getResourceBundle(name, locale, cl);
    }

    @Override
    public String[] getSharedResourceBundleNames() {
        return this.portalResourceBundleNames_;
    }

    @Override
    public ResourceBundleData createResourceBundleDataInstance() {
        return new ResourceBundleData();
    }

    protected boolean isClasspathResource(String name) {
        if (this.classpathResources_ == null) {
            return false;
        }
        for (int i = 0; i < this.classpathResources_.size(); ++i) {
            String pack = this.classpathResources_.get(i);
            if (!name.startsWith(pack)) continue;
            return true;
        }
        return false;
    }

    protected void initResources(String baseName, ClassLoader cl) {
        String name = baseName.replace('.', '/');
        try {
            Collection<LocaleConfig> localeConfigs = this.localeService_.getLocalConfigs();
            Locale defaultLocale = this.localeService_.getDefaultLocaleConfig().getLocale();
            for (LocaleConfig localeConfig : localeConfigs) {
                Locale locale = localeConfig.getLocale();
                String language = locale.getLanguage();
                String country = locale.getCountry();
                String content = this.getResourceBundleContent(name, locale, defaultLocale, cl);
                if (content == null) continue;
                ResourceBundleData data = new ResourceBundleData();
                if (country != null && country.length() > 0) {
                    data.setId(baseName + "_" + language + "_" + country);
                } else {
                    data.setId(baseName + "_" + language);
                }
                data.setName(baseName);
                data.setLanguage(language);
                data.setData(content);
                this.saveResourceBundle(data);
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("Error while reading the resource bundle : " + baseName), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResourceBundleContent(String name, String language, String defaultLang, ClassLoader cl) throws Exception {
        block10: {
            String string;
            String fileName = null;
            cl = new PropertiesClassLoader(cl, true);
            fileName = name + "_" + language + ".properties";
            URL url = cl.getResource(fileName);
            if (url == null && defaultLang.equals(language)) {
                url = cl.getResource(name + ".properties");
            }
            if (url == null) break block10;
            InputStream is = url.openStream();
            try {
                byte[] buf = IOUtil.getStreamContentAsBytes((InputStream)is);
                string = new String(buf, "UTF-8");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Exception("Error while reading the file: " + fileName, e);
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResourceBundleContent(String baseName, Locale locale, Locale defaultLocale, ClassLoader cl) throws Exception {
        block14: {
            String string;
            ArrayList<String> candidateFiles = new ArrayList<String>();
            String language = locale.getLanguage();
            String country = locale.getCountry().toUpperCase();
            String defaultLanguage = defaultLocale.getLanguage();
            String defaultCountry = defaultLocale.getCountry().toUpperCase();
            if (country != null && country.length() > 0) {
                candidateFiles.add(baseName + "_" + language + "_" + country + ".properties");
            }
            if (language != null && language.length() > 0) {
                candidateFiles.add(baseName + "_" + language + ".properties");
            }
            if (defaultCountry != null && defaultCountry.length() > 0) {
                candidateFiles.add(baseName + "_" + defaultLanguage + "_" + defaultCountry + ".properties");
            }
            if (defaultLanguage != null && defaultLanguage.length() > 0) {
                candidateFiles.add(baseName + "_" + defaultLanguage + ".properties");
            }
            candidateFiles.add(baseName + ".properties");
            cl = new PropertiesClassLoader(cl, true);
            String fileName = null;
            URL url = null;
            for (String candidateFile : candidateFiles) {
                url = cl.getResource(candidateFile);
                if (url == null) continue;
                fileName = candidateFile;
                break;
            }
            if (url == null) break block14;
            InputStream is = url.openStream();
            try {
                byte[] buf = IOUtil.getStreamContentAsBytes((InputStream)is);
                string = new String(buf, "UTF-8");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new Exception("Error while reading the file: " + fileName, ex);
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return string;
        }
        return null;
    }

    protected final void invalidate(String name) {
        this.cache_.remove((Serializable)((Object)name));
    }

    @Override
    public ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader cl) {
        boolean isCacheable;
        if (IdentityResourceBundle.MAGIC_LANGUAGE.equals(locale.getLanguage())) {
            return IdentityResourceBundle.getInstance();
        }
        String country = locale.getCountry();
        String id = country != null && country.length() > 0 ? name + "_" + locale.getLanguage() + "_" + locale.getCountry() : name + "_" + locale.getLanguage();
        boolean isClasspathResource = this.isClasspathResource(name);
        boolean bl = isCacheable = !isClasspathResource || !PropertyManager.isDevelopping();
        if (isCacheable && isClasspathResource) {
            id = id + "_" + cl.getClass() + "_" + System.identityHashCode(cl);
        }
        if (isClasspathResource) {
            if (isCacheable) {
                ResourceBundleLoaderContext ctx = new ResourceBundleLoaderContext(name, locale, cl);
                ResourceBundle result = (ResourceBundle)this.getFutureCache().get((Object)ctx, (Object)id);
                if (ctx.e != null) {
                    throw ctx.e;
                }
                return result;
            }
            return ResourceBundleLoader.load(name, locale, cl);
        }
        return (ResourceBundle)this.getFutureCache().get((Object)new GetResourceBundleFromDbContext(name, locale), (Object)id);
    }

    @Override
    public ResourceBundle getResourceBundle(String[] name, Locale locale, ClassLoader cl) {
        if (IdentityResourceBundle.MAGIC_LANGUAGE.equals(locale.getLanguage())) {
            return IdentityResourceBundle.getInstance();
        }
        StringBuilder idBuf = new StringBuilder("merge:");
        for (String n : name) {
            idBuf.append(n).append("_");
        }
        idBuf.append(locale);
        String id = idBuf.toString();
        return (ResourceBundle)this.getFutureCache().get((Object)new GetResourceBundleContext(name, locale, cl), (Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FutureCache<String, ResourceBundle, ResourceBundleContext> getFutureCache() {
        if (this.futureCache_ == null) {
            BaseResourceBundleService baseResourceBundleService = this;
            synchronized (baseResourceBundleService) {
                if (this.futureCache_ == null) {
                    this.futureCache_ = new FutureExoCache(this.loader_, this.cache_);
                }
            }
        }
        return this.futureCache_;
    }

    protected abstract ResourceBundle getResourceBundleFromDb(String var1, ResourceBundle var2, Locale var3) throws Exception;

    private class GetResourceBundleContext
    extends ResourceBundleContext {
        private final String[] name;
        private final Locale locale;
        private final ClassLoader cl;

        public GetResourceBundleContext(String[] name, Locale locale, ClassLoader cl) {
            this.name = name;
            this.locale = locale;
            this.cl = cl;
        }

        ResourceBundle get(String id) {
            MapResourceBundle outputBundled = null;
            try {
                outputBundled = new MapResourceBundle(this.locale);
                for (int i = 0; i < this.name.length; ++i) {
                    ResourceBundle temp = BaseResourceBundleService.this.getResourceBundle(this.name[i], this.locale, this.cl);
                    if (temp != null) {
                        outputBundled.merge(temp);
                        continue;
                    }
                    BaseResourceBundleService.this.log_.warn((Object)("Cannot load and merge the bundle: " + this.name[i]));
                }
                outputBundled.resolveDependencies();
            }
            catch (Exception ex) {
                BaseResourceBundleService.this.log_.error((Object)("Cannot load and merge the bundle: " + id), (Throwable)ex);
            }
            return outputBundled;
        }
    }

    private class GetResourceBundleFromDbContext
    extends ResourceBundleContext {
        private final String name;
        private final Locale locale;

        public GetResourceBundleFromDbContext(String name, Locale locale) {
            this.name = name;
            this.locale = locale;
        }

        ResourceBundle get(String id) {
            ResourceBundle res = null;
            try {
                String rootId = this.name + "_" + BaseResourceBundleService.this.localeService_.getDefaultLocaleConfig().getLanguage();
                ResourceBundle parent = BaseResourceBundleService.this.getResourceBundleFromDb(rootId, null, this.locale);
                if (parent != null && (res = BaseResourceBundleService.this.getResourceBundleFromDb(id, parent, this.locale)) == null) {
                    res = parent;
                }
            }
            catch (Exception ex) {
                BaseResourceBundleService.this.log_.error((Object)("Error: " + id), (Throwable)ex);
            }
            return res;
        }
    }

    private static class ResourceBundleLoaderContext
    extends ResourceBundleContext {
        private final String name;
        private final Locale locale;
        private final ClassLoader cl;
        private RuntimeException e;

        public ResourceBundleLoaderContext(String name, Locale locale, ClassLoader cl) {
            this.name = name;
            this.locale = locale;
            this.cl = cl;
        }

        ResourceBundle get(String id) {
            try {
                return ResourceBundleLoader.load(this.name, this.locale, this.cl);
            }
            catch (RuntimeException e) {
                this.e = e;
                return null;
            }
        }
    }

    private static abstract class ResourceBundleContext {
        private ResourceBundleContext() {
        }

        abstract ResourceBundle get(String var1);
    }
}

