/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.gatein.common.NotYetImplemented;
import org.gatein.common.p3p.P3PConstants;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.oasis.wsrp.v2.Contact;
import org.oasis.wsrp.v2.EmployerInfo;
import org.oasis.wsrp.v2.Online;
import org.oasis.wsrp.v2.PersonName;
import org.oasis.wsrp.v2.Postal;
import org.oasis.wsrp.v2.Telecom;
import org.oasis.wsrp.v2.TelephoneNum;
import org.oasis.wsrp.v2.UserContext;
import org.oasis.wsrp.v2.UserProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserContextConverter {
    private UserContextConverter() {
    }

    public static org.gatein.pc.api.spi.UserContext createPortalUserContextFrom(UserContext userContext, List<String> desiredLocales, String preferredLocale) {
        return new WSRPMappedUserContext(userContext, desiredLocales, preferredLocale);
    }

    public static UserContext createWSRPUserContextFrom(org.gatein.pc.api.spi.UserContext userContext, String userContextKey, List<String> userCategories) {
        UserContext wsrpUserContext = WSRPTypeFactory.createUserContext(userContextKey);
        wsrpUserContext.setProfile(UserContextConverter.createUserProfileFrom(userContext));
        if (ParameterValidation.existsAndIsNotEmpty(userCategories)) {
            wsrpUserContext.getUserCategories().addAll(userCategories);
        }
        return wsrpUserContext;
    }

    private static UserProfile createUserProfileFrom(org.gatein.pc.api.spi.UserContext userContext) {
        Map userInfos = userContext.getInformations();
        if (!ParameterValidation.existsAndIsNotEmpty((Map)userInfos)) {
            return null;
        }
        PersonName name = UserContextConverter.createNameFrom(userInfos);
        XMLGregorianCalendar bdate = null;
        String bdateAsString = (String)userInfos.get("user.bdate");
        if (bdateAsString != null) {
            DatatypeFactory datatypeFactory = null;
            try {
                datatypeFactory = DatatypeFactory.newInstance();
                bdate = datatypeFactory.newXMLGregorianCalendar(bdateAsString);
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        String employer = (String)userInfos.get("user.employer");
        String department = (String)userInfos.get("user.department");
        String jobTitle = (String)userInfos.get("user.jobtitle");
        EmployerInfo employerInfo = WSRPTypeFactory.createEmployerInfo(employer, department, jobTitle);
        Contact homeInfo = UserContextConverter.createContactFrom(userInfos, false);
        Contact businessInfo = UserContextConverter.createContactFrom(userInfos, true);
        UserProfile userProfile = WSRPTypeFactory.createUserProfile(name, bdate, (String)userInfos.get("user.gender"), employerInfo, homeInfo, businessInfo);
        return userProfile;
    }

    private static PersonName createNameFrom(Map<String, String> userInfos) {
        String prefix = userInfos.get("user.name.prefix");
        String given = userInfos.get("user.name.given");
        String family = userInfos.get("user.name.family");
        String middle = userInfos.get("user.name.middle");
        String suffix = userInfos.get("user.name.suffix");
        String nickName = userInfos.get("user.name.nickName");
        PersonName name = WSRPTypeFactory.createPersonName(prefix, given, family, middle, suffix, nickName);
        return name;
    }

    private static Contact createContactFrom(Map<String, String> infos, boolean isBusiness) {
        String email = infos.get(P3PConstants.getOnlineUserInfoKey((P3PConstants.OnlineInfo)P3PConstants.OnlineInfo.EMAIL, (boolean)isBusiness));
        String uri = infos.get(P3PConstants.getOnlineUserInfoKey((P3PConstants.OnlineInfo)P3PConstants.OnlineInfo.URI, (boolean)isBusiness));
        Online online = WSRPTypeFactory.createOnline(email, uri);
        String name = infos.get(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.NAME, (boolean)isBusiness));
        String street = infos.get(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.STREET, (boolean)isBusiness));
        String city = infos.get(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.CITY, (boolean)isBusiness));
        String stateprov = infos.get(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.STATEPROV, (boolean)isBusiness));
        String postalCode = infos.get(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.POSTALCODE, (boolean)isBusiness));
        String country = infos.get(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.COUNTRY, (boolean)isBusiness));
        String organization = infos.get(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.ORGANIZATION, (boolean)isBusiness));
        Postal postal = WSRPTypeFactory.createPostal(name, street, city, stateprov, postalCode, country, organization);
        TelephoneNum telephone = UserContextConverter.createTelephoneNumFrom(infos, P3PConstants.TelecomType.TELEPHONE, isBusiness);
        TelephoneNum fax = UserContextConverter.createTelephoneNumFrom(infos, P3PConstants.TelecomType.FAX, isBusiness);
        TelephoneNum mobile = UserContextConverter.createTelephoneNumFrom(infos, P3PConstants.TelecomType.MOBILE, isBusiness);
        TelephoneNum pager = UserContextConverter.createTelephoneNumFrom(infos, P3PConstants.TelecomType.PAGER, isBusiness);
        Telecom telecom = WSRPTypeFactory.createTelecom(telephone, fax, mobile, pager);
        Contact contact = WSRPTypeFactory.createContact(postal, telecom, online);
        return contact;
    }

    private static TelephoneNum createTelephoneNumFrom(Map<String, String> infos, P3PConstants.TelecomType type, boolean isBusiness) {
        String intCode = infos.get(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.INTCODE, (boolean)isBusiness));
        String loccode = infos.get(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.LOCCODE, (boolean)isBusiness));
        String number = infos.get(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.NUMBER, (boolean)isBusiness));
        String ext = infos.get(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.EXT, (boolean)isBusiness));
        String comment = infos.get(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.COMMENT, (boolean)isBusiness));
        TelephoneNum telephoneNum = WSRPTypeFactory.createTelephoneNum(intCode, loccode, number, ext, comment);
        return telephoneNum;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WSRPMappedUserContext
    implements org.gatein.pc.api.spi.UserContext {
        private Map<String, String> infos;
        private List<String> desiredLocales;
        private Locale locale;
        private String id;

        public WSRPMappedUserContext(UserContext userContext, List<String> desiredLocales, String preferredLocale) {
            this.desiredLocales = desiredLocales;
            this.locale = WSRPUtils.getLocale(preferredLocale);
            if (userContext != null) {
                String key;
                UserProfile profile = userContext.getProfile();
                if (profile != null) {
                    this.infos = new HashMap<String, String>();
                    XMLGregorianCalendar bdate = profile.getBdate();
                    if (bdate != null) {
                        this.infos.put("user.bdate", bdate.toString());
                    }
                    this.infos.put("user.gender", profile.getGender());
                    PersonName name = profile.getName();
                    if (name != null) {
                        this.infos.put("user.name.family", name.getFamily());
                        this.infos.put("user.name.given", name.getGiven());
                        this.infos.put("user.name.middle", name.getMiddle());
                        this.infos.put("user.name.nickName", name.getNickname());
                        this.infos.put("user.name.prefix", name.getPrefix());
                        this.infos.put("user.name.suffix", name.getSuffix());
                    }
                    this.populateContactInfo(profile.getBusinessInfo(), true);
                    this.populateContactInfo(profile.getHomeInfo(), false);
                    EmployerInfo employerInfo = profile.getEmployerInfo();
                    if (employerInfo != null) {
                        this.infos.put("user.department", employerInfo.getDepartment());
                        this.infos.put("user.employer", employerInfo.getEmployer());
                        this.infos.put("user.jobtitle", employerInfo.getJobtitle());
                    }
                }
                if ((key = userContext.getUserContextKey()) == null) {
                    throw new IllegalArgumentException("Missing required userContextKey in UserContext!");
                }
                this.id = key;
            } else {
                this.infos = Collections.emptyMap();
            }
        }

        public String getId() {
            return this.id;
        }

        public Map getInformations() {
            return this.infos;
        }

        private void populateContactInfo(Contact contact, boolean isBusiness) {
            if (contact != null) {
                Telecom telecom;
                Postal postal;
                Online online = contact.getOnline();
                if (online != null) {
                    this.infos.put(P3PConstants.getOnlineUserInfoKey((P3PConstants.OnlineInfo)P3PConstants.OnlineInfo.EMAIL, (boolean)isBusiness), online.getEmail());
                    this.infos.put(P3PConstants.getOnlineUserInfoKey((P3PConstants.OnlineInfo)P3PConstants.OnlineInfo.URI, (boolean)isBusiness), online.getUri());
                }
                if ((postal = contact.getPostal()) != null) {
                    this.infos.put(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.NAME, (boolean)isBusiness), postal.getName());
                    this.infos.put(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.STREET, (boolean)isBusiness), postal.getStreet());
                    this.infos.put(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.CITY, (boolean)isBusiness), postal.getCity());
                    this.infos.put(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.STATEPROV, (boolean)isBusiness), postal.getStateprov());
                    this.infos.put(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.POSTALCODE, (boolean)isBusiness), postal.getPostalcode());
                    this.infos.put(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.COUNTRY, (boolean)isBusiness), postal.getCountry());
                    this.infos.put(P3PConstants.getPostalUserInfoKey((P3PConstants.PostalInfo)P3PConstants.PostalInfo.ORGANIZATION, (boolean)isBusiness), postal.getOrganization());
                }
                if ((telecom = contact.getTelecom()) != null) {
                    this.populateTelephoneInfo(telecom.getFax(), P3PConstants.TelecomType.FAX, isBusiness);
                    this.populateTelephoneInfo(telecom.getMobile(), P3PConstants.TelecomType.MOBILE, isBusiness);
                    this.populateTelephoneInfo(telecom.getPager(), P3PConstants.TelecomType.PAGER, isBusiness);
                    this.populateTelephoneInfo(telecom.getTelephone(), P3PConstants.TelecomType.TELEPHONE, isBusiness);
                }
            }
        }

        private void populateTelephoneInfo(TelephoneNum telephoneNum, P3PConstants.TelecomType type, boolean isBusiness) {
            if (telephoneNum != null) {
                this.infos.put(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.INTCODE, (boolean)isBusiness), telephoneNum.getIntcode());
                this.infos.put(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.LOCCODE, (boolean)isBusiness), telephoneNum.getLoccode());
                this.infos.put(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.NUMBER, (boolean)isBusiness), telephoneNum.getNumber());
                this.infos.put(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.EXT, (boolean)isBusiness), telephoneNum.getExt());
                this.infos.put(P3PConstants.getTelecomInfoKey((P3PConstants.TelecomType)type, (P3PConstants.TelecomInfo)P3PConstants.TelecomInfo.COMMENT, (boolean)isBusiness), telephoneNum.getComment());
            }
        }

        public Locale getLocale() {
            return this.locale;
        }

        public List<Locale> getLocales() {
            List<Locale> locales = Collections.emptyList();
            if (ParameterValidation.existsAndIsNotEmpty(this.desiredLocales)) {
                locales = new ArrayList<Locale>(this.desiredLocales.size());
                for (String desiredLocale : this.desiredLocales) {
                    Locale locale = WSRPUtils.getLocale(desiredLocale);
                    locales.add(locale);
                }
            }
            return locales;
        }

        public Object getAttribute(String arg0) {
            throw new NotYetImplemented();
        }

        public void setAttribute(String arg0, Object arg1) {
            throw new NotYetImplemented();
        }
    }
}

