/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.core.MethodInvoker;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.mapper.MethodMapper;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.spi.instrument.Instrumentor;
import org.chromattic.spi.instrument.ProxyFactory;
import org.reflext.api.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMapper<C extends ObjectContext>
implements MethodInvoker<C> {
    protected final Class<?> objectClass;
    private final String nodeTypeName;
    final Set<MethodMapper<C>> methodMappers;
    final Set<PropertyMapper<?, C>> propertyMappers;
    private final ProxyFactory factory;
    private final Map<Method, MethodInvoker<C>> dispatchers;
    private final ObjectFormatter formatter;
    private final NameConflictResolution onDuplicate;
    private final NodeTypeKind kind;

    public ObjectMapper(Class<?> objectClass, Set<PropertyMapper<?, C>> propertyMappers, Set<MethodMapper<C>> methodMappers, NameConflictResolution onDuplicate, ObjectFormatter formatter, Instrumentor instrumentor, String typeName, NodeTypeKind kind) {
        HashMap<Method, MethodInvoker<C>> dispatchers = new HashMap<Method, MethodInvoker<C>>();
        for (PropertyMapper<?, C> propertyMapper : propertyMappers) {
            MethodInfo setter;
            Object info = propertyMapper.getInfo();
            MethodInfo getter = info.getGetter();
            if (getter != null) {
                dispatchers.put((Method)getter.getMethod(), propertyMapper);
            }
            if ((setter = info.getSetter()) == null) continue;
            dispatchers.put((Method)setter.getMethod(), propertyMapper);
        }
        for (MethodMapper methodMapper : methodMappers) {
            dispatchers.put(methodMapper.getMethod(), methodMapper);
        }
        this.dispatchers = dispatchers;
        this.objectClass = objectClass;
        this.methodMappers = methodMappers;
        this.formatter = formatter;
        this.onDuplicate = onDuplicate;
        this.propertyMappers = propertyMappers;
        this.factory = instrumentor.getProxyClass(objectClass);
        this.nodeTypeName = typeName;
        this.kind = kind;
    }

    @Override
    public Object invoke(C ctx, Method method, Object[] args) throws Throwable {
        int i;
        MethodInvoker<C> invoker = this.dispatchers.get(method);
        if (invoker != null) {
            return invoker.invoke(ctx, method, args);
        }
        StringBuilder msg = new StringBuilder("Cannot invoke method ").append(method.getName()).append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                msg.append(',');
            }
            msg.append(parameterTypes[i].getName());
        }
        msg.append(") with arguments (");
        for (i = 0; i < args.length; ++i) {
            if (i > 0) {
                msg.append(',');
            }
            msg.append(String.valueOf(args[i]));
        }
        msg.append(")");
        throw new AssertionError(msg);
    }

    public NodeTypeKind getKind() {
        return this.kind;
    }

    public String getNodeTypeName() {
        return this.nodeTypeName;
    }

    public ObjectFormatter getFormatter() {
        return this.formatter;
    }

    public Object createObject(C context) {
        return this.factory.createProxy(context);
    }

    public Set<MethodMapper<C>> getMethodMappers() {
        return this.methodMappers;
    }

    public Set<PropertyMapper<?, C>> getPropertyMappers() {
        return this.propertyMappers;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public NameConflictResolution getOnDuplicate() {
        return this.onDuplicate;
    }

    public String toString() {
        return "EntityMapper[class=" + this.objectClass + ",typeName=" + this.nodeTypeName + "]";
    }
}

