/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.consumer.migration.BaseMigrationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportInfo
extends BaseMigrationInfo {
    private final byte[] exportContext;
    private long expirationTime;
    private final SortedMap<String, byte[]> handleToExportedState;
    private static final SortedMap<String, byte[]> EMPTY_EXPORTED = new TreeMap<String, byte[]>();

    public ExportInfo(long exportTime, SortedMap<QName, List<String>> errorCodeToHandles, SortedMap<String, byte[]> handleToState, byte[] exportContext) {
        super(exportTime, errorCodeToHandles);
        this.handleToExportedState = ParameterValidation.existsAndIsNotEmpty(handleToState) ? handleToState : EMPTY_EXPORTED;
        this.exportContext = exportContext;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getHumanReadableExpirationTime(Locale locale) {
        return this.getHumanReadableTime(locale, this.expirationTime);
    }

    public List<String> getExportedPortletHandles() {
        return new ArrayList<String>(this.handleToExportedState.keySet());
    }

    public byte[] getPortletStateFor(String portletHandle) {
        return (byte[])this.handleToExportedState.get(portletHandle);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportInfo that = (ExportInfo)o;
        return this.exportTime == that.exportTime;
    }

    public int hashCode() {
        return (int)(this.exportTime ^ this.exportTime >>> 32);
    }

    public byte[] getExportContext() {
        return this.exportContext;
    }
}

