/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;

public abstract class ExportData {
    protected static final String ENCODING = "UTF-8";
    protected static final String SEPARATOR = "_@_";

    public abstract double getVersion();

    public abstract String getType();

    protected abstract byte[] internalEncodeAsBytes() throws UnsupportedEncodingException, IOException;

    public byte[] encodeAsBytes() throws IOException {
        byte[] internalBytes = this.internalEncodeAsBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeUTF(this.getType());
        oos.writeDouble(this.getVersion());
        if (internalBytes != null) {
            oos.write(internalBytes);
        }
        oos.close();
        return baos.toByteArray();
    }

    public static double getVersion(byte[] bytes) throws IOException {
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            String type = ois.readUTF();
            Double version = ois.readDouble();
            return version;
        }
        return -1.0;
    }

    public static String getType(byte[] bytes) throws IOException {
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readUTF();
        }
        return null;
    }

    public static byte[] getInternalBytes(byte[] bytes) throws IOException {
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            String type = ois.readUTF();
            Double version = ois.readDouble();
            byte[] internalBytes = null;
            if (ois.available() > 0) {
                internalBytes = new byte[ois.available()];
                ois.readFully(internalBytes);
            }
            return internalBytes;
        }
        return null;
    }
}

