/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.AbstractRegistrationPersistenceManager;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.impl.ConsumerGroupImpl;
import org.gatein.registration.impl.ConsumerImpl;
import org.gatein.registration.impl.RegistrationImpl;
import org.gatein.registration.spi.ConsumerGroupSPI;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationPersistenceManagerImpl
extends AbstractRegistrationPersistenceManager {
    private long lastRegistrationId;
    private Map<String, ConsumerSPI> consumers = new HashMap<String, ConsumerSPI>();
    private Map<String, ConsumerGroupSPI> groups = new HashMap<String, ConsumerGroupSPI>();
    private Map<String, RegistrationSPI> registrations = new HashMap<String, RegistrationSPI>();

    public Collection<ConsumerSPI> getConsumers() {
        return Collections.unmodifiableCollection(this.consumers.values());
    }

    public Collection<RegistrationSPI> getRegistrations() {
        return Collections.unmodifiableCollection(this.registrations.values());
    }

    public Collection<ConsumerGroupSPI> getConsumerGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    @Override
    public Registration getRegistration(String registrationId) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration id", null);
        return this.registrations.get(registrationId);
    }

    @Override
    public ConsumerGroup getConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"ConsumerGroup name", null);
        return this.groups.get(name);
    }

    @Override
    public Consumer getConsumerById(String consumerId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        return this.consumers.get(consumerId);
    }

    @Override
    protected void internalAddRegistration(RegistrationSPI registration) {
        this.registrations.put(registration.getPersistentKey(), registration);
    }

    @Override
    protected RegistrationSPI internalRemoveRegistration(String registrationId) {
        return this.registrations.remove(registrationId);
    }

    @Override
    protected RegistrationSPI internalCreateRegistration(ConsumerSPI consumer, Map<QName, Object> registrationProperties) {
        return this.newRegistrationSPI(consumer, registrationProperties, "" + this.lastRegistrationId++);
    }

    public RegistrationSPI newRegistrationSPI(ConsumerSPI consumer, Map<QName, Object> registrationProperties, String registrationKey) {
        return new RegistrationImpl(registrationKey, consumer, RegistrationStatus.PENDING, registrationProperties);
    }

    @Override
    protected void internalAddConsumer(ConsumerSPI consumer) {
        this.consumers.put(consumer.getId(), consumer);
    }

    @Override
    protected ConsumerSPI internalRemoveConsumer(String consumerId) {
        return this.consumers.remove(consumerId);
    }

    @Override
    protected ConsumerSPI internalCreateConsumer(String consumerId, String consumerName) {
        ConsumerSPI consumerSPI = this.newConsumerSPI(consumerId, consumerName);
        consumerSPI.setPersistentKey(consumerId);
        return consumerSPI;
    }

    public ConsumerSPI newConsumerSPI(String consumerId, String consumerName) {
        return new ConsumerImpl(consumerId, consumerName);
    }

    @Override
    protected void internalAddConsumerGroup(ConsumerGroupSPI group) {
        this.groups.put(group.getName(), group);
    }

    @Override
    protected ConsumerGroupSPI internalRemoveConsumerGroup(String name) {
        return this.groups.remove(name);
    }

    @Override
    protected ConsumerGroupSPI internalCreateConsumerGroup(String name) {
        ConsumerGroupSPI groupSPI = this.newConsumerGroupSPI(name);
        groupSPI.setPersistentKey(name);
        return groupSPI;
    }

    public ConsumerGroupSPI newConsumerGroupSPI(String name) {
        return new ConsumerGroupImpl(name);
    }

    @Override
    protected ConsumerSPI getConsumerSPIById(String consumerId) throws RegistrationException {
        return (ConsumerSPI)this.getConsumerById(consumerId);
    }

    @Override
    protected ConsumerSPI internalSaveChangesTo(Consumer consumer) {
        return (ConsumerSPI)consumer;
    }

    @Override
    protected RegistrationSPI internalSaveChangesTo(Registration registration) {
        return (RegistrationSPI)registration;
    }
}

