/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.util.ParameterValidation;
import org.gatein.exports.data.ExportContext;
import org.gatein.exports.data.ExportPortletData;
import org.gatein.pc.api.InvalidPortletIdException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.PreferenceInfo;
import org.gatein.pc.api.info.PreferencesInfo;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationLocal;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.PortletManagementInterface;
import org.gatein.wsrp.producer.Utils;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.handlers.ServiceHandler;
import org.gatein.wsrp.spec.v2.ErrorCodes;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.ClonePortlet;
import org.oasis.wsrp.v2.CopiedPortlet;
import org.oasis.wsrp.v2.CopyPortlets;
import org.oasis.wsrp.v2.CopyPortletsResponse;
import org.oasis.wsrp.v2.DestroyPortlets;
import org.oasis.wsrp.v2.DestroyPortletsResponse;
import org.oasis.wsrp.v2.ExportByValueNotSupported;
import org.oasis.wsrp.v2.ExportPortlets;
import org.oasis.wsrp.v2.ExportPortletsResponse;
import org.oasis.wsrp.v2.ExportedPortlet;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.FailedPortlets;
import org.oasis.wsrp.v2.GetPortletDescription;
import org.oasis.wsrp.v2.GetPortletProperties;
import org.oasis.wsrp.v2.GetPortletPropertyDescription;
import org.oasis.wsrp.v2.GetPortletsLifetime;
import org.oasis.wsrp.v2.GetPortletsLifetimeResponse;
import org.oasis.wsrp.v2.ImportPortlet;
import org.oasis.wsrp.v2.ImportPortlets;
import org.oasis.wsrp.v2.ImportPortletsFailed;
import org.oasis.wsrp.v2.ImportPortletsResponse;
import org.oasis.wsrp.v2.ImportedPortlet;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.PortletDescriptionResponse;
import org.oasis.wsrp.v2.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.PropertyDescription;
import org.oasis.wsrp.v2.PropertyList;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ReleaseExport;
import org.oasis.wsrp.v2.ResetProperty;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.SetExportLifetime;
import org.oasis.wsrp.v2.SetPortletProperties;
import org.oasis.wsrp.v2.SetPortletsLifetime;
import org.oasis.wsrp.v2.SetPortletsLifetimeResponse;
import org.oasis.wsrp.v2.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletManagementHandler
extends ServiceHandler
implements PortletManagementInterface {
    private static final String GET_PORTLET_PROPERTY_DESCRIPTION = "GetPortletPropertyDescription";
    private static final String GET_PORTLET_PROPERTIES = "GetPortletProperties";
    private static final String PORTLET_CONTEXT = "PortletContext";
    private static final String GET_PORTLET_DESCRIPTION = "GetPortletDescription";
    private static final Logger log = LoggerFactory.getLogger(PortletManagementHandler.class);

    public PortletManagementHandler(WSRPProducerImpl producer) {
        super(producer);
    }

    @Override
    public PortletDescriptionResponse getPortletDescription(GetPortletDescription getPortletDescription) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getPortletDescription, (String)GET_PORTLET_DESCRIPTION);
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(getPortletDescription.getRegistrationContext());
        PortletContext portletContext = getPortletDescription.getPortletContext();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)GET_PORTLET_DESCRIPTION);
        UserContext userContext = getPortletDescription.getUserContext();
        this.checkUserAuthorization(userContext);
        PortletDescription description = this.producer.getPortletDescription(portletContext, getPortletDescription.getDesiredLocales(), registration);
        return WSRPTypeFactory.createPortletDescriptionResponse((PortletDescription)description);
    }

    @Override
    public PortletPropertyDescriptionResponse getPortletPropertyDescription(GetPortletPropertyDescription getPortletPropertyDescription) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getPortletPropertyDescription, (String)GET_PORTLET_PROPERTY_DESCRIPTION);
        PortletContext portletContext = getPortletPropertyDescription.getPortletContext();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)GET_PORTLET_PROPERTY_DESCRIPTION);
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(getPortletPropertyDescription.getRegistrationContext());
        UserContext userContext = getPortletPropertyDescription.getUserContext();
        this.checkUserAuthorization(userContext);
        List desiredLocales = getPortletPropertyDescription.getDesiredLocales();
        Portlet portlet = this.getPortletFrom(portletContext, registration);
        PortletInfo info = portlet.getInfo();
        PreferencesInfo prefsInfo = info.getPreferences();
        List descs = Collections.emptyList();
        if (prefsInfo != null) {
            Set keySet = prefsInfo.getKeys();
            descs = new ArrayList(keySet.size());
            for (Object key : keySet) {
                PreferenceInfo prefInfo = prefsInfo.getPreference((String)key);
                Boolean readOnly = prefInfo.isReadOnly();
                if (readOnly == null || readOnly.booleanValue()) continue;
                PropertyDescription desc = WSRPTypeFactory.createPropertyDescription((String)prefInfo.getKey(), (QName)WSRPConstants.XSD_STRING);
                desc.setLabel(Utils.convertToWSRPLocalizedString(prefInfo.getDisplayName(), desiredLocales));
                desc.setHint(Utils.convertToWSRPLocalizedString(prefInfo.getDescription(), desiredLocales));
                descs.add(desc);
            }
        }
        return WSRPTypeFactory.createPortletPropertyDescriptionResponse(descs);
    }

    @Override
    public PortletContext clonePortlet(ClonePortlet clonePortlet) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)clonePortlet, (String)"ClonePortlet");
        PortletContext portletContext = clonePortlet.getPortletContext();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)"ClonePortlet");
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(clonePortlet.getRegistrationContext());
        UserContext userContext = clonePortlet.getUserContext();
        this.checkUserAuthorization(userContext);
        org.gatein.pc.api.PortletContext portalPC = WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext);
        try {
            RegistrationLocal.setRegistration(registration);
            org.gatein.pc.api.PortletContext response = this.producer.getPortletInvoker().createClone(PortletStateType.OPAQUE, portalPC);
            PortletContext portletContext2 = WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)response);
            return portletContext2;
        }
        catch (NoSuchPortletException e) {
            throw (InvalidHandle)WSRP2ExceptionFactory.throwWSException(InvalidHandle.class, (String)("Failed to create clone for portlet '" + portletContext.getPortletHandle()), (Throwable)e);
        }
        catch (InvalidPortletIdException e) {
            throw (InconsistentParameters)WSRP2ExceptionFactory.throwWSException(InconsistentParameters.class, (String)("Failed to create clone for portlet '" + portletContext.getPortletHandle()), (Throwable)e);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Failed to create clone for portlet '" + portletContext.getPortletHandle()), (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    @Override
    public DestroyPortletsResponse destroyPortlets(DestroyPortlets destroyPortlets) throws InconsistentParameters, InvalidRegistration, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)destroyPortlets, (String)"DestroyPortlets");
        List handles = destroyPortlets.getPortletHandles();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)handles, (String)"portlet handles to be destroyed", (String)"DestroyPortlets");
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(destroyPortlets.getRegistrationContext());
        ArrayList<org.gatein.pc.api.PortletContext> portletContexts = new ArrayList<org.gatein.pc.api.PortletContext>(handles.size());
        for (String handle : handles) {
            portletContexts.add(org.gatein.pc.api.PortletContext.createPortletContext((String)handle));
        }
        try {
            ArrayList<FailedPortlets> failedPortlets;
            RegistrationLocal.setRegistration(registration);
            List failuresList = this.producer.getPortletInvoker().destroyClones(portletContexts);
            int failuresNumber = failuresList.size();
            if (failuresNumber > 0) {
                HashMultimap reasonToHandles = HashMultimap.create((int)failuresNumber, (int)1);
                for (DestroyCloneFailure failure : failuresList) {
                    reasonToHandles.put((Object)failure.getMessage(), (Object)failure.getPortletId());
                }
                failedPortlets = new ArrayList<FailedPortlets>(reasonToHandles.size());
                for (String reason : reasonToHandles.keys()) {
                    failedPortlets.add(WSRPTypeFactory.createFailedPortlets((Collection)reasonToHandles.get((Object)reason), (ErrorCodes.Codes)ErrorCodes.Codes.OPERATIONFAILED, (String)reason));
                }
            } else {
                failedPortlets = null;
            }
            DestroyPortletsResponse destroyPortletsResponse = WSRPTypeFactory.createDestroyPortletsResponse(failedPortlets);
            return destroyPortletsResponse;
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Failed to destroy clones", (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    @Override
    public GetPortletsLifetimeResponse getPortletsLifetime(GetPortletsLifetime getPortletsLifetime) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        throw (OperationNotSupported)WSRP2ExceptionFactory.throwWSException(OperationNotSupported.class, (String)"Lifetime operations are not currently supported.", null);
    }

    @Override
    public SetPortletsLifetimeResponse setPortletsLifetime(SetPortletsLifetime setPortletsLifetime) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        throw (OperationNotSupported)WSRP2ExceptionFactory.throwWSException(OperationNotSupported.class, (String)"Lifetime operations are not currently supported.", null);
    }

    @Override
    public CopyPortletsResponse copyPortlets(CopyPortlets copyPortlets) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)copyPortlets, (String)"copyPortlets");
        List portletContexts = copyPortlets.getFromPortletContexts();
        if (!ParameterValidation.existsAndIsNotEmpty((Collection)portletContexts)) {
            throw (MissingParameters)WSRP2ExceptionFactory.createWSException(MissingParameters.class, (String)"Missing required portletContext in CopyPortlets.", null);
        }
        Registration fromRegistration = this.producer.getRegistrationOrFailIfInvalid(copyPortlets.getFromRegistrationContext());
        RegistrationContext toRegistationContext = copyPortlets.getToRegistrationContext();
        if (toRegistationContext == null) {
            toRegistationContext = copyPortlets.getFromRegistrationContext();
        }
        Registration toRegistration = this.producer.getRegistrationOrFailIfInvalid(toRegistationContext);
        UserContext fromUserContext = copyPortlets.getFromUserContext();
        this.checkUserAuthorization(fromUserContext);
        UserContext toUserContext = copyPortlets.getToUserContext();
        this.checkUserAuthorization(toUserContext);
        try {
            CopyPortletsResponse copyPortletsResponse;
            RegistrationLocal.setRegistration(fromRegistration);
            HashMap<String, FailedPortlets> failedPortletsMap = new HashMap<String, FailedPortlets>(portletContexts.size());
            ArrayList<CopiedPortlet> copiedPortlets = new ArrayList<CopiedPortlet>(portletContexts.size());
            for (PortletContext portletContext : portletContexts) {
                try {
                    org.gatein.pc.api.PortletContext portalPC = WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext);
                    org.gatein.pc.api.PortletContext exportedPortletContext = this.producer.getPortletInvoker().exportPortlet(PortletStateType.OPAQUE, portalPC);
                    RegistrationLocal.setRegistration(toRegistration);
                    org.gatein.pc.api.PortletContext copiedPortletContext = this.producer.getPortletInvoker().importPortlet(PortletStateType.OPAQUE, exportedPortletContext);
                    PortletContext wsrpClonedPC = WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)copiedPortletContext);
                    CopiedPortlet copiedPortlet = WSRPTypeFactory.createCopiedPortlet((PortletContext)wsrpClonedPC, (String)portletContext.getPortletHandle());
                    copiedPortlets.add(copiedPortlet);
                }
                catch (Exception e) {
                    String reason;
                    ErrorCodes.Codes errorCode;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Error occured while trying to export a portlet.", (Throwable)e);
                    }
                    if (e instanceof NoSuchPortletException || e instanceof InvalidHandle) {
                        errorCode = ErrorCodes.Codes.INVALIDHANDLE;
                        reason = "The specified portlet handle is invalid";
                    } else {
                        errorCode = ErrorCodes.Codes.OPERATIONFAILED;
                        reason = "Error preparing portlet for export";
                    }
                    if (!failedPortletsMap.containsKey(errorCode.name())) {
                        ArrayList<String> portletHandles = new ArrayList<String>();
                        portletHandles.add(portletContext.getPortletHandle());
                        FailedPortlets failedPortlets = WSRPTypeFactory.createFailedPortlets(portletHandles, (ErrorCodes.Codes)errorCode, (String)reason);
                        failedPortletsMap.put(errorCode.name(), failedPortlets);
                        continue;
                    }
                    FailedPortlets failedPortlets = (FailedPortlets)failedPortletsMap.get(errorCode.name());
                    failedPortlets.getPortletHandles().add(portletContext.getPortletHandle());
                }
            }
            ArrayList failedPortlets = new ArrayList(failedPortletsMap.values());
            ResourceList resourceList = null;
            CopyPortletsResponse copyPortletsResponse2 = copyPortletsResponse = WSRPTypeFactory.createCopyPortletsResponse(copiedPortlets, failedPortlets, resourceList);
            return copyPortletsResponse2;
        }
        catch (Exception e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Operation Failed while trying to CopyPortlets.", (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    @Override
    public PortletContext setPortletProperties(SetPortletProperties setPortletProperties) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)setPortletProperties, (String)"SetPortletProperties");
        PortletContext portletContext = setPortletProperties.getPortletContext();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)"SetPortletProperties");
        PropertyList propertyList = setPortletProperties.getPropertyList();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)propertyList, (String)"PropertyList", (String)"SetPortletProperties");
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(setPortletProperties.getRegistrationContext());
        this.checkUserAuthorization(setPortletProperties.getUserContext());
        List properties = propertyList.getProperties();
        List resetProperties = propertyList.getResetProperties();
        int changesCount = 0;
        if (ParameterValidation.existsAndIsNotEmpty((Collection)properties)) {
            changesCount += properties.size();
            if (ParameterValidation.existsAndIsNotEmpty((Collection)resetProperties)) {
                ArrayList names = new ArrayList(WSRPUtils.transform((List)properties, (Function)new Function<Property, QName>(){

                    public QName apply(Property from) {
                        return from.getName();
                    }
                }));
                names.retainAll(WSRPUtils.transform((List)resetProperties, (Function)new Function<ResetProperty, QName>(){

                    public QName apply(ResetProperty from) {
                        return from.getName();
                    }
                }));
                if (!names.isEmpty()) {
                    WSRP2ExceptionFactory.throwWSException(InconsistentParameters.class, (String)("Attempted to set and reset at the same time the following properties: " + names), null);
                }
            }
        }
        if (ParameterValidation.existsAndIsNotEmpty((Collection)resetProperties)) {
            changesCount += resetProperties.size();
        }
        if (changesCount > 0) {
            ArrayList<PropertyChange> changes = new ArrayList<PropertyChange>(changesCount);
            if (properties != null) {
                for (Property property : properties) {
                    String value = property.getStringValue();
                    changes.add(PropertyChange.newUpdate((String)property.getName().toString(), (String)value));
                }
            }
            if (resetProperties != null) {
                for (ResetProperty resetProperty : resetProperties) {
                    changes.add(PropertyChange.newReset((String)resetProperty.getName().toString()));
                }
            }
            try {
                RegistrationLocal.setRegistration(registration);
                org.gatein.pc.api.PortletContext resultContext = this.producer.getPortletInvoker().setProperties(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext), changes.toArray(new PropertyChange[changes.size()]));
                PortletContext portletContext2 = WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)resultContext);
                return portletContext2;
            }
            catch (NoSuchPortletException e) {
                throw (InvalidHandle)WSRP2ExceptionFactory.throwWSException(InvalidHandle.class, (String)("Failed to set properties for portlet '" + portletContext.getPortletHandle() + "'"), (Throwable)e);
            }
            catch (InvalidPortletIdException e) {
                throw (InconsistentParameters)WSRP2ExceptionFactory.throwWSException(InconsistentParameters.class, (String)("Failed to set properties for portlet '" + portletContext.getPortletHandle() + "'"), (Throwable)e);
            }
            catch (PortletInvokerException e) {
                throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Failed to set properties for portlet '" + portletContext.getPortletHandle() + "'"), (Throwable)e);
            }
            finally {
                RegistrationLocal.setRegistration(null);
            }
        }
        return portletContext;
    }

    @Override
    public PropertyList getPortletProperties(GetPortletProperties getPortletProperties) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getPortletProperties, (String)GET_PORTLET_PROPERTIES);
        PortletContext portletContext = getPortletProperties.getPortletContext();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)GET_PORTLET_PROPERTIES);
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(getPortletProperties.getRegistrationContext());
        UserContext userContext = getPortletProperties.getUserContext();
        this.checkUserAuthorization(userContext);
        List names = getPortletProperties.getNames();
        HashSet keys = new HashSet(names);
        try {
            org.gatein.pc.api.PortletContext jbpContext = WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext);
            RegistrationLocal.setRegistration(registration);
            PropertyMap properties = keys != null ? this.producer.getPortletInvoker().getProperties(jbpContext, keys) : this.producer.getPortletInvoker().getProperties(jbpContext);
            Portlet portlet = this.getPortletFrom(portletContext, registration);
            PortletInfo info = portlet.getInfo();
            PropertyList result = WSRPTypeFactory.createPropertyList();
            int propertyNb = properties.size();
            if (propertyNb > 0) {
                for (Map.Entry entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    PreferenceInfo prefInfo = info.getPreferences().getPreference(key);
                    LocalizedString displayName = prefInfo.getDisplayName();
                    String lang = WSRPUtils.toString((Locale)displayName.getDefaultLocale());
                    if (values.size() != 1) {
                        throw new UnsupportedOperationException("Currently doesn't support multi-valued properties!");
                    }
                    result.getProperties().add(WSRPTypeFactory.createProperty((String)key, (String)lang, (String)((String)values.get(0))));
                }
            }
            PropertyList propertyList = result;
            return propertyList;
        }
        catch (PortletInvokerException e) {
            throw (InvalidHandle)WSRP2ExceptionFactory.throwWSException(InvalidHandle.class, (String)("Could not retrieve properties for portlet '" + portletContext + "'"), (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    @Override
    public ExportPortletsResponse exportPortlets(ExportPortlets exportPortlets) throws AccessDenied, ExportByValueNotSupported, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)exportPortlets, (String)"ExportPortlets", (String)"ExportPortlets");
        List portletContexts = exportPortlets.getPortletContext();
        if (!ParameterValidation.existsAndIsNotEmpty((Collection)portletContexts)) {
            throw (MissingParameters)WSRP2ExceptionFactory.createWSException(MissingParameters.class, (String)"Missing required portletContext in ExportPortlets.", null);
        }
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(exportPortlets.getRegistrationContext());
        UserContext userContext = exportPortlets.getUserContext();
        this.checkUserAuthorization(userContext);
        boolean exportByValueRequired = exportPortlets.isExportByValueRequired() != null ? exportPortlets.isExportByValueRequired() : false;
        if (exportByValueRequired && !this.producer.getExportManager().supportsExportByValue()) {
            WSRP2ExceptionFactory.throwWSException(ExportByValueNotSupported.class, (String)"The consumer is requesting portlets to be exported by value, but this consumer only supports export by reference.", null);
        }
        ArrayList<ExportedPortlet> exportedPortlets = new ArrayList<ExportedPortlet>(portletContexts.size());
        HashMap<String, FailedPortlets> failedPortletsMap = new HashMap<String, FailedPortlets>(portletContexts.size());
        try {
            ExportContext exportContext;
            RegistrationLocal.setRegistration(registration);
            if (exportPortlets.getLifetime() != null) {
                long currentTime = this.toLongDate(exportPortlets.getLifetime().getCurrentTime());
                long terminationTime = this.toLongDate(exportPortlets.getLifetime().getTerminationTime());
                long refreshDuration = exportPortlets.getLifetime().getRefreshDuration().getTimeInMillis(exportPortlets.getLifetime().getCurrentTime().toGregorianCalendar());
                exportContext = this.producer.getExportManager().createExportContext(exportByValueRequired, currentTime, terminationTime, refreshDuration);
            } else {
                exportContext = this.producer.getExportManager().createExportContext(exportByValueRequired, -1L, -1L, -1L);
            }
            for (PortletContext portletContext : exportPortlets.getPortletContext()) {
                try {
                    String portletHandle = portletContext.getPortletHandle();
                    byte[] portletState = portletContext.getPortletState();
                    WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)portletHandle, (String)"Portlet handle");
                    org.gatein.pc.api.PortletContext portalPC = WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext);
                    this.producer.getPortletInvoker().getPortlet(portalPC);
                    org.gatein.pc.api.PortletContext exportedPortalPC = this.producer.getPortletInvoker().exportPortlet(PortletStateType.OPAQUE, portalPC);
                    PortletContext exportedPortalContext = WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)exportedPortalPC);
                    portletHandle = exportedPortalContext.getPortletHandle();
                    portletState = exportedPortalContext.getPortletState();
                    if (exportedPortalPC == null) {
                        WSRP2ExceptionFactory.throwWSException(InvalidHandle.class, (String)("Could not find a portlet with handle " + portletHandle + " in the producer"), null);
                    }
                    ExportPortletData exportPortletData = this.producer.getExportManager().createExportPortletData(exportContext, portletHandle, portletState);
                    byte[] exportPortletBytes = this.producer.getExportManager().encodeExportPortletData(exportContext, exportPortletData);
                    ExportedPortlet exportedPortlet = WSRPTypeFactory.createExportedPortlet((String)portletHandle, (byte[])exportPortletData.encodeAsBytes());
                    exportedPortlets.add(exportedPortlet);
                }
                catch (Exception e) {
                    String reason;
                    ErrorCodes.Codes errorCode;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Error occured while trying to export a portlet.", (Throwable)e);
                    }
                    if (e instanceof NoSuchPortletException || e instanceof InvalidHandle) {
                        errorCode = ErrorCodes.Codes.INVALIDHANDLE;
                        reason = "The specified portlet handle is invalid";
                    } else {
                        errorCode = ErrorCodes.Codes.OPERATIONFAILED;
                        reason = "Error preparing portlet for export";
                    }
                    if (!failedPortletsMap.containsKey(errorCode.name())) {
                        ArrayList<String> portletHandles = new ArrayList<String>();
                        portletHandles.add(portletContext.getPortletHandle());
                        FailedPortlets failedPortlets = WSRPTypeFactory.createFailedPortlets(portletHandles, (ErrorCodes.Codes)errorCode, (String)reason);
                        failedPortletsMap.put(errorCode.name(), failedPortlets);
                        continue;
                    }
                    FailedPortlets failedPortlets = (FailedPortlets)failedPortletsMap.get(errorCode.name());
                    failedPortlets.getPortletHandles().add(portletContext.getPortletHandle());
                }
            }
            ResourceList resourceList = null;
            byte[] exportContextBytes = this.producer.getExportManager().encodeExportContextData(exportContext);
            Lifetime lifetime = null;
            if (exportContext.getCurrentTime() > 0L) {
                lifetime = new Lifetime();
                lifetime.setCurrentTime(this.toXMLGregorianCalendar(exportContext.getCurrentTime()));
                lifetime.setTerminationTime(this.toXMLGregorianCalendar(exportContext.getTermintationTime()));
                lifetime.setRefreshDuration(this.toDuration(exportContext.getRefreshDuration()));
            }
            ExportPortletsResponse exportPortletsResponse = WSRPTypeFactory.createExportPortletsResponse((byte[])exportContextBytes, exportedPortlets, new ArrayList(failedPortletsMap.values()), (Lifetime)lifetime, resourceList);
            return exportPortletsResponse;
        }
        catch (Exception e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Operation Failed while trying to ExportPortlets.", (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportPortletsResponse importPortlets(ImportPortlets importPortlets) throws OperationFailed, InvalidRegistration, MissingParameters, ModifyRegistrationRequired {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)importPortlets, (String)"ImportPortlets");
        List importPortletList = importPortlets.getImportPortlet();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)importPortletList, (String)"ImportPortlet", (String)"ImportPortlets");
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(importPortlets.getRegistrationContext());
        UserContext userContext = importPortlets.getUserContext();
        this.checkUserAuthorization(userContext);
        try {
            ExportContext exportContext;
            RegistrationLocal.setRegistration(registration);
            byte[] importContext = importPortlets.getImportContext();
            Lifetime lifeTime = importPortlets.getLifetime();
            ArrayList<ImportedPortlet> importedPortlets = new ArrayList<ImportedPortlet>();
            HashMap<String, ImportPortletsFailed> failedPortletsMap = new HashMap<String, ImportPortletsFailed>();
            try {
                exportContext = this.producer.getExportManager().createExportContext(importContext);
            }
            catch (Exception e) {
                throw (OperationFailed)WSRPExceptionFactory.createWSException(OperationFailed.class, (String)"Invalid ImportContext.", (Throwable)e);
            }
            for (ImportPortlet importPortlet : importPortletList) {
                try {
                    ExportPortletData exportPortletData;
                    byte[] portletData = importPortlet.getExportData();
                    if (lifeTime != null) {
                        long currentTime = this.toLongDate(lifeTime.getCurrentTime());
                        long terminationTime = this.toLongDate(lifeTime.getTerminationTime());
                        long refreshDuration = lifeTime.getRefreshDuration().getTimeInMillis(lifeTime.getCurrentTime().toGregorianCalendar());
                        exportPortletData = this.producer.getExportManager().createExportPortletData(exportContext, currentTime, terminationTime, refreshDuration, portletData);
                    } else {
                        exportPortletData = this.producer.getExportManager().createExportPortletData(exportContext, -1L, -1L, -1L, portletData);
                    }
                    String portletHandle = exportPortletData.getPortletHandle();
                    byte[] portletState = exportPortletData.getPortletState();
                    PortletContext pc = WSRPTypeFactory.createPortletContext((String)portletHandle, (byte[])portletState);
                    org.gatein.pc.api.PortletContext pcPortletContext = WSRPUtils.convertToPortalPortletContext((PortletContext)pc);
                    org.gatein.pc.api.PortletContext cpc = this.producer.getPortletInvoker().importPortlet(PortletStateType.OPAQUE, pcPortletContext);
                    PortletContext wpc = WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)cpc);
                    ImportedPortlet importedPortlet = WSRPTypeFactory.createImportedPortlet((String)importPortlet.getImportID(), (PortletContext)wpc);
                    importedPortlets.add(importedPortlet);
                }
                catch (Exception e) {
                    String reason;
                    ErrorCodes.Codes errorCode;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Error occured while trying to import a portlet.", (Throwable)e);
                    }
                    if (e instanceof NoSuchPortletException || e instanceof InvalidHandle) {
                        errorCode = ErrorCodes.Codes.INVALIDHANDLE;
                        reason = "The specified portlet handle is invalid";
                    } else if (e instanceof OperationFailed) {
                        errorCode = ErrorCodes.Codes.OPERATIONFAILED;
                        reason = e.getMessage();
                    } else if (e instanceof PortletInvokerException || e instanceof UnsupportedOperationException || e instanceof IllegalArgumentException) {
                        errorCode = ErrorCodes.Codes.OPERATIONFAILED;
                        reason = "Error trying to create imported portlet.";
                    } else {
                        errorCode = ErrorCodes.Codes.OPERATIONFAILED;
                        reason = "Error preparing portlet for export";
                    }
                    if (!failedPortletsMap.containsKey(errorCode.name())) {
                        ArrayList<String> portleIDs = new ArrayList<String>();
                        portleIDs.add(importPortlet.getImportID());
                        ImportPortletsFailed failedPortlets = WSRPTypeFactory.createImportPortletsFailed(portleIDs, (ErrorCodes.Codes)errorCode, (String)reason);
                        failedPortletsMap.put(errorCode.name(), failedPortlets);
                        continue;
                    }
                    ImportPortletsFailed failedPortlets = (ImportPortletsFailed)failedPortletsMap.get(errorCode.name());
                    failedPortlets.getImportID().add(importPortlet.getImportID());
                }
            }
            ResourceList resourceList = null;
            ImportPortletsResponse importPortletsResponse = WSRPTypeFactory.createImportPortletsResponse(importedPortlets, new ArrayList(failedPortletsMap.values()), resourceList);
            return importPortletsResponse;
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    @Override
    public List<Extension> releaseExport(ReleaseExport releaseExport) {
        block3: {
            try {
                if (releaseExport != null && releaseExport.getExportContext() != null) {
                    this.producer.getExportManager().releaseExport(releaseExport.getExportContext());
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Error occured while trying to perform a ReleaseExport", (Throwable)e);
            }
        }
        return WSRPTypeFactory.createReturnAny().getExtensions();
    }

    @Override
    public Lifetime setExportLifetime(SetExportLifetime setExportLifetime) throws OperationFailed, InvalidRegistration, OperationNotSupported, ModifyRegistrationRequired {
        if (this.producer.getExportManager().getPersistenceManager() == null) {
            WSRP2ExceptionFactory.throwWSException(OperationNotSupported.class, (String)"This producer does not support export by reference.", null);
        }
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)setExportLifetime, (String)"setExportLifetimePortlets");
        byte[] exportContextBytes = setExportLifetime.getExportContext();
        if (exportContextBytes == null) {
            WSRPExceptionFactory.throwWSException(OperationFailed.class, (String)"Cannot call setExportLifetime with an empty ExportContext.", null);
        }
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(setExportLifetime.getRegistrationContext());
        UserContext userContext = setExportLifetime.getUserContext();
        this.checkUserAuthorization(userContext);
        try {
            ExportContext exportContext;
            RegistrationLocal.setRegistration(registration);
            if (setExportLifetime != null) {
                long currentTime = this.toLongDate(setExportLifetime.getLifetime().getCurrentTime());
                long terminationTime = this.toLongDate(setExportLifetime.getLifetime().getTerminationTime());
                long refreshDuration = setExportLifetime.getLifetime().getRefreshDuration().getTimeInMillis(setExportLifetime.getLifetime().getCurrentTime().toGregorianCalendar());
                exportContext = this.producer.getExportManager().setExportLifetime(exportContextBytes, currentTime, terminationTime, refreshDuration);
            } else {
                exportContext = this.producer.getExportManager().setExportLifetime(exportContextBytes, -1L, -1L, -1L);
            }
            Lifetime lifetime = this.getLifetime(exportContext);
            return lifetime;
        }
        catch (Exception e) {
            throw (OperationFailed)WSRPExceptionFactory.createWSException(OperationFailed.class, (String)"Operation Failed while trying to setExportLifetime.", (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    private void checkUserAuthorization(UserContext userContext) {
        if (userContext != null) {
            // empty if block
        }
    }

    private Portlet getPortletFrom(PortletContext portletContext, Registration registration) throws InvalidHandle {
        try {
            Portlet portlet;
            RegistrationLocal.setRegistration(registration);
            Portlet portlet2 = portlet = this.producer.getPortletInvoker().getPortlet(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext));
            return portlet2;
        }
        catch (PortletInvokerException e) {
            throw (InvalidHandle)WSRP2ExceptionFactory.throwWSException(InvalidHandle.class, (String)("Could not retrieve portlet '" + portletContext.getPortletHandle() + "'"), (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    private XMLGregorianCalendar toXMLGregorianCalendar(long time) throws DatatypeConfigurationException {
        Date date = new Date(time);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
    }

    private long toLongDate(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar().getTime().getTime();
    }

    private Duration toDuration(long duration) throws DatatypeConfigurationException {
        return DatatypeFactory.newInstance().newDuration(duration);
    }

    private Lifetime getLifetime(ExportContext exportContext) throws DatatypeConfigurationException {
        if (exportContext.getCurrentTime() >= 0L) {
            Lifetime lifetime = new Lifetime();
            XMLGregorianCalendar currentTime = this.toXMLGregorianCalendar(exportContext.getCurrentTime());
            XMLGregorianCalendar terminationTime = this.toXMLGregorianCalendar(exportContext.getTermintationTime());
            Duration duration = this.toDuration(exportContext.getRefreshDuration());
            lifetime.setCurrentTime(currentTime);
            lifetime.setTerminationTime(terminationTime);
            lifetime.setRefreshDuration(duration);
            return lifetime;
        }
        return null;
    }
}

