/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetoone.hierarchical;

import org.chromattic.common.logging.Logger;
import org.chromattic.core.EntityContext;
import org.chromattic.core.NameKind;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.mapper.JCRNodePropertyMapper;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.chromattic.metamodel.mapping.RelationshipMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRNamedChildParentPropertyMapper<O extends ObjectContext<O>>
extends JCRNodePropertyMapper<SingleValuedPropertyInfo<BeanValueInfo>, BeanValueInfo, O> {
    private String relatedName;
    private final String relatedPrefix;
    private final Logger log = Logger.getLogger(JCRNamedChildParentPropertyMapper.class);

    public JCRNamedChildParentPropertyMapper(Class<O> contextType, RelationshipMapping.OneToOne.Hierarchic info) throws ClassNotFoundException {
        super(contextType, info);
        this.relatedName = info.getLocalName();
        this.relatedPrefix = info.getPrefix();
    }

    @Override
    public Object get(O ctx) throws Throwable {
        String externalRelatedName;
        EntityContext entityCtx = ((ObjectContext)ctx).getEntity();
        EntityContext childCtx = entityCtx.getChild(this.relatedPrefix, externalRelatedName = entityCtx.decodeName(this.relatedName, NameKind.OBJECT));
        if (childCtx != null) {
            Object o = childCtx.getObject();
            Class<?> relatedClass = this.getRelatedClass();
            if (relatedClass.isInstance(o)) {
                return o;
            }
            throw new ClassCastException();
        }
        return null;
    }

    @Override
    public void set(O context, Object child) throws Throwable {
        EntityContext entity = ((ObjectContext)context).getEntity();
        String externalRelatedName = entity.decodeName(this.relatedName, NameKind.OBJECT);
        if (child != null) {
            EntityContext entityCtx = entity.getSession().unwrapEntity(child);
            entity.addChild(this.relatedPrefix, externalRelatedName, entityCtx);
        } else {
            entity.removeChild(this.relatedPrefix, externalRelatedName);
        }
    }
}

