/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractNamespaceMappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedNamespaceMappings
extends AbstractNamespaceMappings {
    private static Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.NamespaceMappings");
    private final File storage;
    private Map prefixToURI = new HashMap();
    private Map uriToPrefix = new HashMap();
    private int prefixCount;

    public FileBasedNamespaceMappings(File file) throws IOException {
        this.storage = file;
        this.load();
    }

    public synchronized String getNamespaceURIByPrefix(String prefix) throws NamespaceException {
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return (String)this.prefixToURI.get(prefix);
    }

    public synchronized String getNamespacePrefixByURI(String uri) throws NamespaceException {
        String prefix = (String)this.uriToPrefix.get(uri);
        if (prefix == null) {
            while (this.prefixToURI.get(String.valueOf(this.prefixCount)) != null) {
                ++this.prefixCount;
            }
            prefix = String.valueOf(this.prefixCount);
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            log.debug("adding new namespace mapping: " + prefix + " -> " + uri);
            try {
                this.store();
            }
            catch (IOException e) {
                throw new NamespaceException("Could not obtain a prefix for uri: " + uri, (Throwable)e);
            }
        }
        return prefix;
    }

    private void load() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                if (FileBasedNamespaceMappings.this.storage.exists()) {
                    FileInputStream in = PrivilegedFileHelper.fileInputStream((File)FileBasedNamespaceMappings.this.storage);
                    try {
                        Properties props = new Properties();
                        log.debug("loading namespace mappings...");
                        props.load(in);
                        for (String string : props.keySet()) {
                            String uri = props.getProperty(string);
                            log.debug(string + " -> " + uri);
                            FileBasedNamespaceMappings.this.prefixToURI.put(string, uri);
                            FileBasedNamespaceMappings.this.uriToPrefix.put(uri, string);
                        }
                        FileBasedNamespaceMappings.this.prefixCount = props.size();
                        log.debug("namespace mappings loaded.");
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    ((InputStream)in).close();
                    {
                    }
                }
                return null;
            }
        });
    }

    private void store() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Properties props = new Properties();
                for (String prefix : FileBasedNamespaceMappings.this.prefixToURI.keySet()) {
                    String uri = (String)FileBasedNamespaceMappings.this.prefixToURI.get(prefix);
                    props.setProperty(prefix, uri);
                }
                OutputStream out = PrivilegedFileHelper.fileOutputStream((File)FileBasedNamespaceMappings.this.storage);
                try {
                    out = new BufferedOutputStream(out);
                    props.store(out, null);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    out.close();
                    throw throwable;
                }
                out.close();
                return null;
            }
        });
    }

    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.prefixToURI.keySet().toArray(new String[this.prefixToURI.keySet().size()]);
    }
}

