/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.BackupException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.Backupable;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.CleanException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.DataCleaner;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.RestoreException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.util.BackupTables;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.util.RestoreTableRule;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.util.RestoreTables;
import org.exoplatform.services.jcr.impl.storage.jdbc.cleaner.DBCleanHelper;
import org.exoplatform.services.jcr.impl.storage.jdbc.cleaner.DBCleaner;
import org.exoplatform.services.jcr.impl.storage.jdbc.cleaner.IngresSQLDBCleaner;
import org.exoplatform.services.jcr.impl.storage.jdbc.cleaner.OracleDBCleaner;
import org.exoplatform.services.jcr.impl.storage.jdbc.cleaner.PgSQLDBCleaner;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.HSQLDBConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MySQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.OracleConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.IngresSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.OracleDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.PgSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.statistics.StatisticsJDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.update.StorageUpdateManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

public class JDBCWorkspaceDataContainer
extends WorkspaceDataContainerBase
implements Startable,
Backupable {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCWorkspaceDataContainer");
    public static final boolean STATISTICS_ENABLED = Boolean.valueOf(PrivilegedSystemHelper.getProperty((String)"JDBCWorkspaceDataContainer.statistics.enabled"));
    public static final String SOURCE_NAME = "source-name";
    public static final String MULTIDB = "multi-db";
    public static final String SINGLEDB = "single-db";
    public static final String DB_DIALECT = "dialect";
    public static final String DB_DRIVER = "driverClassName";
    public static final String DB_URL = "url";
    public static final String DB_USERNAME = "username";
    public static final String DB_PASSWORD = "password";
    public static final String DB_FORCE_QUERY_HINTS = "force.query.hints";
    protected final String containerName;
    protected final String dbSourceName;
    protected final boolean multiDb;
    protected final String dbDriver;
    protected final String dbDialect;
    protected final String dbUrl;
    protected final String dbUserName;
    protected final String dbPassword;
    protected final ValueStoragePluginProvider valueStorageProvider;
    protected String storageVersion;
    protected boolean checkSNSNewConnection;
    protected int maxBufferSize;
    protected File swapDirectory;
    protected FileCleaner swapCleaner;
    protected GenericConnectionFactory connFactory;
    protected boolean useQueryHints;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JDBCWorkspaceDataContainer(WorkspaceEntry wsConfig, RepositoryEntry repConfig, InitialContextInitializer contextInit, ValueStoragePluginProvider valueStorageProvider, FileCleanerHolder fileCleanerHolder) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        boolean enableStorageUpdate;
        block32: {
            block31: {
                String pDbDialect;
                block35: {
                    String sn;
                    block33: {
                        block34: {
                            contextInit.recall();
                            this.checkIntegrity(wsConfig, repConfig);
                            this.containerName = wsConfig.getName();
                            this.multiDb = Boolean.parseBoolean(wsConfig.getContainer().getParameterValue(MULTIDB));
                            this.valueStorageProvider = valueStorageProvider;
                            pDbDialect = null;
                            try {
                                pDbDialect = this.validateDialect(wsConfig.getContainer().getParameterValue(DB_DIALECT));
                            }
                            catch (RepositoryConfigurationException e) {
                                pDbDialect = DBConstants.DB_DIALECT_GENERIC;
                            }
                            String pDbDriver = null;
                            String pDbUrl = null;
                            String pDbUserName = null;
                            String pDbPassword = null;
                            try {
                                pDbDriver = wsConfig.getContainer().getParameterValue(DB_DRIVER);
                                try {
                                    pDbUserName = wsConfig.getContainer().getParameterValue(DB_USERNAME);
                                    pDbPassword = wsConfig.getContainer().getParameterValue(DB_PASSWORD);
                                }
                                catch (RepositoryConfigurationException e) {
                                    pDbPassword = null;
                                    pDbUserName = null;
                                }
                                pDbUrl = wsConfig.getContainer().getParameterValue(DB_URL);
                            }
                            catch (RepositoryConfigurationException e) {
                                // empty catch block
                            }
                            if (pDbUrl == null) break block33;
                            this.dbDriver = pDbDriver;
                            this.dbUrl = pDbUrl;
                            this.dbUserName = pDbUserName;
                            this.dbPassword = pDbPassword;
                            this.dbSourceName = null;
                            LOG.info((Object)("Connect to JCR database as user '" + this.dbUserName + "'"));
                            if (pDbDialect != DBConstants.DB_DIALECT_GENERIC && !DBConstants.DB_DIALECT_AUTO.equalsIgnoreCase(pDbDialect)) break block34;
                            Connection jdbcConn = null;
                            try {
                                try {
                                    jdbcConn = this.dbUserName != null ? DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword) : DriverManager.getConnection(this.dbUrl);
                                    this.dbDialect = DialectDetecter.detect(jdbcConn.getMetaData());
                                }
                                catch (SQLException e) {
                                    throw new RepositoryException((Throwable)e);
                                }
                                Object var14_18 = null;
                                if (jdbcConn == null) break block31;
                            }
                            catch (Throwable throwable) {
                                Object var14_19 = null;
                                if (jdbcConn == null) throw throwable;
                                try {
                                    jdbcConn.close();
                                    throw throwable;
                                }
                                catch (SQLException e) {
                                    throw new RepositoryException((Throwable)e);
                                }
                            }
                            try {}
                            catch (SQLException e) {
                                throw new RepositoryException((Throwable)e);
                            }
                            jdbcConn.close();
                            break block31;
                        }
                        this.dbDialect = pDbDialect;
                        break block31;
                    }
                    this.dbDriver = null;
                    this.dbUrl = null;
                    this.dbUserName = null;
                    this.dbPassword = null;
                    try {
                        sn = wsConfig.getContainer().getParameterValue(SOURCE_NAME);
                    }
                    catch (RepositoryConfigurationException e) {
                        sn = wsConfig.getContainer().getParameterValue("sourceName");
                    }
                    this.dbSourceName = sn;
                    if (pDbDialect != DBConstants.DB_DIALECT_GENERIC) break block35;
                    final DataSource ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                    if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                    Connection jdbcConn = null;
                    try {
                        try {
                            jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                                @Override
                                public Connection run() throws Exception {
                                    return ds.getConnection();
                                }
                            });
                            this.dbDialect = DialectDetecter.detect(jdbcConn.getMetaData());
                        }
                        catch (SQLException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        Object var17_30 = null;
                        if (jdbcConn == null) break block31;
                    }
                    catch (Throwable throwable) {
                        Object var17_31 = null;
                        if (jdbcConn == null) throw throwable;
                        try {
                            jdbcConn.close();
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                    }
                    try {}
                    catch (SQLException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                    jdbcConn.close();
                    break block31;
                }
                this.dbDialect = pDbDialect;
            }
            LOG.info((Object)("Using a dialect '" + this.dbDialect + "'"));
            this.useQueryHints = wsConfig.getContainer().getParameterBoolean(DB_FORCE_QUERY_HINTS, true);
            try {
                this.checkSNSNewConnection = wsConfig.getContainer().getParameterBoolean("check-sns-new-connection");
            }
            catch (RepositoryConfigurationException e) {
                this.checkSNSNewConnection = !DBConstants.DB_DIALECT_SYBASE.equals(this.dbDialect);
            }
            try {
                this.maxBufferSize = wsConfig.getContainer().getParameterInteger("max-buffer-size");
            }
            catch (RepositoryConfigurationException e) {
                this.maxBufferSize = 204800;
            }
            try {
                String sdParam = wsConfig.getContainer().getParameterValue("swap-directory");
                this.swapDirectory = new File(sdParam);
            }
            catch (RepositoryConfigurationException e1) {
                this.swapDirectory = new File(DEF_SWAPDIR);
            }
            if (!PrivilegedFileHelper.exists((File)this.swapDirectory)) {
                PrivilegedFileHelper.mkdirs((File)this.swapDirectory);
            }
            this.swapCleaner = fileCleanerHolder.getFileCleaner();
            this.initDatabase();
            String suParam = null;
            enableStorageUpdate = false;
            try {
                suParam = wsConfig.getContainer().getParameterValue("update-storage");
                enableStorageUpdate = Boolean.parseBoolean(suParam);
            }
            catch (RepositoryConfigurationException e) {
                if (!LOG.isDebugEnabled()) break block32;
                LOG.debug((Object)("update-storage parameter is not set " + this.dbSourceName));
            }
        }
        this.storageVersion = StorageUpdateManager.checkVersion(this.dbSourceName, this.connFactory.getJdbcConnection(), this.multiDb, enableStorageUpdate);
        LOG.info((Object)this.getInfo());
    }

    protected GenericConnectionFactory defaultConnectionFactory() throws NamingException, RepositoryException {
        if (this.dbSourceName != null) {
            DataSource ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
            if (ds != null) {
                return new GenericConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
        }
        return new GenericConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
    }

    protected StorageDBInitializer defaultDBInitializer(String sqlPath) throws NamingException, RepositoryException, IOException {
        return new StorageDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
    }

    protected void checkIntegrity(WorkspaceEntry wsConfig, RepositoryEntry repConfig) throws RepositoryConfigurationException {
        for (WorkspaceEntry wsEntry : repConfig.getWorkspaceEntries()) {
            if (wsEntry.getName().equals(wsConfig.getName()) || !wsEntry.getContainer().getType().equals(wsConfig.getContainer().getType()) || !wsEntry.getContainer().getType().equals(this.getClass().getName())) continue;
            if (!wsEntry.getContainer().getParameterValue(MULTIDB).equals(wsConfig.getContainer().getParameterValue(MULTIDB))) {
                throw new RepositoryConfigurationException("All workspaces must be multi-db or single-db. But " + wsEntry.getName() + "- multi-db=" + wsEntry.getContainer().getParameterValue(MULTIDB) + " and " + wsConfig.getName() + "- multi-db=" + wsConfig.getContainer().getParameterValue(MULTIDB));
            }
            boolean isMulti = Boolean.parseBoolean(wsConfig.getContainer().getParameterValue(MULTIDB));
            String wsSourceName = null;
            String newWsSourceName = null;
            try {
                wsSourceName = wsEntry.getContainer().getParameterValue("sourceName");
                newWsSourceName = wsConfig.getContainer().getParameterValue("sourceName");
            }
            catch (RepositoryConfigurationException e) {
                // empty catch block
            }
            if (wsSourceName != null && newWsSourceName != null) {
                if (isMulti) {
                    if (!wsSourceName.equals(newWsSourceName)) continue;
                    throw new RepositoryConfigurationException("SourceName " + wsSourceName + " alredy in use in " + wsEntry.getName() + ". SourceName must be different in " + MULTIDB + ". Check configuration for " + wsConfig.getName());
                }
                if (wsSourceName.equals(newWsSourceName)) continue;
                throw new RepositoryConfigurationException("SourceName must be equals in single-db repository. Check " + wsEntry.getName() + " and " + wsConfig.getName());
            }
            String wsUri = null;
            String newWsUri = null;
            try {
                wsUri = wsEntry.getContainer().getParameterValue("db-url");
                newWsUri = wsConfig.getContainer().getParameterValue("db-url");
            }
            catch (RepositoryConfigurationException e) {
                // empty catch block
            }
            if (wsUri == null || newWsUri == null) continue;
            if (isMulti) {
                if (!wsUri.equals(newWsUri)) continue;
                throw new RepositoryConfigurationException("db-url  " + wsUri + " alredy in use in " + wsEntry.getName() + ". db-url must be different in " + MULTIDB + ". Check configuration for " + wsConfig.getName());
            }
            if (wsUri.equals(newWsUri)) continue;
            throw new RepositoryConfigurationException("db-url must be equals in single-db repository. Check " + wsEntry.getName() + " and " + wsConfig.getName());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initDatabase() throws NamingException, RepositoryException, IOException {
        DataSource ds;
        Object var1_1 = null;
        String sqlPath = null;
        if (this.dbDialect == DBConstants.DB_DIALECT_ORACLEOCI) {
            LOG.warn((Object)(DBConstants.DB_DIALECT_ORACLEOCI + " dialect is experimental!"));
            this.connFactory = this.dbSourceName != null ? this.defaultConnectionFactory() : new OracleConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ora.sql";
            OracleDBInitializer oracleDBInitializer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_ORACLE) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ora.sql";
            OracleDBInitializer oracleDBInitializer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_PGSQL) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.pgsql.sql";
            PgSQLDBInitializer pgSQLDBInitializer = new PgSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new MySQLConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            } else {
                this.connFactory = new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mysql.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL_UTF8) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new MySQLConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            } else {
                this.connFactory = new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mysql-utf8.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MSSQL) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mssql.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DERBY) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.derby.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.db2.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2V8) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.db2v8.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_SYBASE) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.sybase.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_INGRES) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ingres.sql";
            IngresSQLDBInitializer ingresSQLDBInitializer = new IngresSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_HSQLDB) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new HSQLDBConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            } else {
                this.connFactory = new HSQLDBConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        }
        try {
            void var1_15;
            var1_15.init();
            return;
        }
        catch (DBInitializerException e) {
            LOG.error((Object)("Error of init db " + e), (Throwable)e);
        }
    }

    protected GenericConnectionFactory getConnectionFactory() {
        return this.connFactory;
    }

    protected String validateDialect(String confParam) {
        for (String dbType : DBConstants.DB_DIALECTS) {
            if (!dbType.equalsIgnoreCase(confParam)) continue;
            return dbType;
        }
        return DBConstants.DB_DIALECT_GENERIC;
    }

    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        WorkspaceStorageConnection con = this.connFactory.openConnection();
        if (STATISTICS_ENABLED) {
            con = new StatisticsJDBCStorageConnection(con);
        }
        return con;
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        WorkspaceStorageConnection con = this.connFactory.openConnection(readOnly);
        if (STATISTICS_ENABLED) {
            con = new StatisticsJDBCStorageConnection(con);
        }
        return con;
    }

    public WorkspaceStorageConnection reuseConnection(WorkspaceStorageConnection original) throws RepositoryException {
        if (original instanceof StatisticsJDBCStorageConnection) {
            original = ((StatisticsJDBCStorageConnection)original).getNestedWorkspaceStorageConnection();
        }
        if (original instanceof JDBCStorageConnection) {
            SharedConnectionFactory cFactory = new SharedConnectionFactory(((JDBCStorageConnection)original).getJdbcConnection(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            return STATISTICS_ENABLED ? new StatisticsJDBCStorageConnection(cFactory.openConnection()) : cFactory.openConnection();
        }
        return this.openConnection();
    }

    public String getName() {
        return this.containerName;
    }

    public String getInfo() {
        String str = "JDBC based JCR Workspace Data container \ncontainer name: " + this.containerName + " \n" + "data source JNDI name: " + this.dbSourceName + "\n" + "is multi database: " + this.multiDb + "\n" + "storage version: " + this.storageVersion + "\n" + "value storage provider: " + this.valueStorageProvider + "\n" + "max buffer size (bytes): " + this.maxBufferSize + "\n" + "swap directory path: " + PrivilegedFileHelper.getAbsolutePath((File)this.swapDirectory);
        return str;
    }

    public String getStorageVersion() {
        return this.storageVersion;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isSame(WorkspaceDataContainer another) {
        if (another == this) {
            return true;
        }
        if (another instanceof JDBCWorkspaceDataContainer) {
            JDBCWorkspaceDataContainer anotherJdbc = (JDBCWorkspaceDataContainer)another;
            if (this.getDbSourceName() != null) {
                return this.getDbSourceName().equals(anotherJdbc.getDbSourceName());
            }
            return this.getDbDriver().equals(anotherJdbc.getDbDriver()) && this.getDbUrl().equals(anotherJdbc.getDbUrl()) && this.getDbUserName().equals(anotherJdbc.getDbUserName());
        }
        return false;
    }

    protected String getDbSourceName() {
        return this.dbSourceName;
    }

    protected String getDbDriver() {
        return this.dbDriver;
    }

    protected String getDbUrl() {
        return this.dbUrl;
    }

    protected String getDbUserName() {
        return this.dbUserName;
    }

    public boolean isCheckSNSNewConnection() {
        return this.checkSNSNewConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void backup(File storageDir) throws BackupException {
        ObjectWriter backupInfo = null;
        try {
            try {
                backupInfo = new ObjectWriterImpl(PrivilegedFileHelper.fileOutputStream((File)new File(storageDir, "JDBCWorkspaceDataContainer.info")));
                backupInfo.writeString(this.containerName);
                backupInfo.writeBoolean(this.multiDb);
                HashMap<String, String> scripts = new HashMap<String, String>();
                if (this.multiDb) {
                    scripts.put("JCR_MITEM", "select * from JCR_MITEM where JCR_MITEM.name <> '__root_parent'");
                    scripts.put("JCR_MVALUE", "select * from JCR_MVALUE");
                    scripts.put("JCR_MREF", "select * from JCR_MREF");
                } else {
                    scripts.put("JCR_SITEM", "select * from JCR_SITEM where CONTAINER_NAME='" + this.containerName + "'");
                    scripts.put("JCR_SVALUE", "select * from JCR_SVALUE where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SVALUE.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + this.containerName + "')");
                    scripts.put("JCR_SREF", "select * from JCR_SREF where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SREF.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + this.containerName + "')");
                }
                BackupTables.backup(storageDir, this.dbSourceName, scripts);
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
            Object var5_5 = null;
            if (backupInfo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (backupInfo == null) throw throwable;
            try {
                backupInfo.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new BackupException(e);
        }
        backupInfo.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restore(File storageDir) throws RestoreException {
        ObjectReader backupInfo = null;
        try {
            try {
                HashSet<Integer> convertColumnIndex;
                backupInfo = new ObjectReaderImpl(PrivilegedFileHelper.fileInputStream((File)new File(storageDir, "JDBCWorkspaceDataContainer.info")));
                String srcContainerName = backupInfo.readString();
                boolean srcMultiDb = backupInfo.readBoolean();
                LinkedHashMap<String, RestoreTableRule> tables = new LinkedHashMap<String, RestoreTableRule>();
                String dstTableName = "JCR_" + (this.multiDb ? "M" : "S") + "ITEM";
                String srcTableName = "JCR_" + (srcMultiDb ? "M" : "S") + "ITEM";
                RestoreTableRule restoreTableRule = new RestoreTableRule();
                restoreTableRule.setSrcContainerName(srcContainerName);
                restoreTableRule.setSrcMultiDb(srcMultiDb);
                restoreTableRule.setDstContainerName(this.containerName);
                restoreTableRule.setDstMultiDb(this.multiDb);
                restoreTableRule.setContentFile(new File(storageDir, srcTableName + ".dump"));
                restoreTableRule.setContentLenFile(new File(storageDir, srcTableName + ".len"));
                if (this.multiDb) {
                    if (!srcMultiDb) {
                        restoreTableRule.setDeleteColumnIndex(4);
                        convertColumnIndex = new HashSet();
                        convertColumnIndex.add(0);
                        convertColumnIndex.add(1);
                        restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                    }
                } else if (srcMultiDb) {
                    restoreTableRule.setNewColumnIndex(4);
                    restoreTableRule.setNewColumnName("CONTAINER_NAME");
                    restoreTableRule.setNewColumnType(12);
                    convertColumnIndex = new HashSet();
                    convertColumnIndex.add(0);
                    convertColumnIndex.add(1);
                    restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                } else {
                    convertColumnIndex = new HashSet<Integer>();
                    convertColumnIndex.add(0);
                    convertColumnIndex.add(1);
                    convertColumnIndex.add(4);
                    restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                }
                tables.put(dstTableName, restoreTableRule);
                dstTableName = "JCR_" + (this.multiDb ? "M" : "S") + "VALUE";
                srcTableName = "JCR_" + (srcMultiDb ? "M" : "S") + "VALUE";
                restoreTableRule = new RestoreTableRule();
                restoreTableRule.setSrcContainerName(srcContainerName);
                restoreTableRule.setSrcMultiDb(srcMultiDb);
                restoreTableRule.setDstContainerName(this.containerName);
                restoreTableRule.setDstMultiDb(this.multiDb);
                restoreTableRule.setContentFile(new File(storageDir, srcTableName + ".dump"));
                restoreTableRule.setContentLenFile(new File(storageDir, srcTableName + ".len"));
                restoreTableRule.setSkipColumnIndex(0);
                if (!this.multiDb || !srcMultiDb) {
                    convertColumnIndex = new HashSet();
                    convertColumnIndex.add(3);
                    restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                }
                tables.put(dstTableName, restoreTableRule);
                dstTableName = "JCR_" + (this.multiDb ? "M" : "S") + "REF";
                srcTableName = "JCR_" + (srcMultiDb ? "M" : "S") + "REF";
                restoreTableRule = new RestoreTableRule();
                restoreTableRule.setSrcContainerName(srcContainerName);
                restoreTableRule.setSrcMultiDb(srcMultiDb);
                restoreTableRule.setDstContainerName(this.containerName);
                restoreTableRule.setDstMultiDb(this.multiDb);
                restoreTableRule.setContentFile(new File(storageDir, srcTableName + ".dump"));
                restoreTableRule.setContentLenFile(new File(storageDir, srcTableName + ".len"));
                if (!this.multiDb || !srcMultiDb) {
                    convertColumnIndex = new HashSet();
                    convertColumnIndex.add(0);
                    convertColumnIndex.add(1);
                    restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                }
                tables.put(dstTableName, restoreTableRule);
                File tempDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
                RestoreTables restoreTable = new RestoreTables(this.swapCleaner, tempDir, this.maxBufferSize);
                restoreTable.restore(storageDir, this.dbSourceName, tables);
            }
            catch (FileNotFoundException e) {
                throw new RestoreException(e);
            }
            catch (IOException e) {
                throw new RestoreException(e);
            }
            Object var12_13 = null;
            if (backupInfo == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (backupInfo == null) throw throwable;
            try {
                backupInfo.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RestoreException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new RestoreException(e);
        }
        backupInfo.close();
    }

    public DataCleaner getDataCleaner() throws CleanException {
        try {
            DBCleaner dbCleaner;
            final DataSource ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
            if (ds == null) {
                throw new NameNotFoundException("Data source " + this.dbSourceName + " not found");
            }
            Connection jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    return ds.getConnection();
                }
            });
            String dialect = DialectDetecter.detect(jdbcConn.getMetaData());
            ArrayList<String> cleanScripts = new ArrayList<String>();
            if (this.multiDb) {
                cleanScripts.add("drop table JCR_MREF");
                cleanScripts.add("drop table JCR_MVALUE");
                cleanScripts.add("drop table JCR_MITEM");
            } else {
                cleanScripts.add("delete from JCR_SVALUE where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SVALUE.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + this.containerName + "')");
                cleanScripts.add("delete from JCR_SREF where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SREF.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + this.containerName + "')");
            }
            if (!this.multiDb && dialect.equals(DBConstants.DB_DIALECT_HSQLDB)) {
                cleanScripts.add("delete from JCR_SITEM where I_CLASS=2 and CONTAINER_NAME='" + this.containerName + "'");
                dbCleaner = new DBCleaner(jdbcConn, cleanScripts, new DBCleanHelper(this.containerName, jdbcConn));
            } else {
                if (!this.multiDb) {
                    cleanScripts.add("delete from JCR_SITEM where CONTAINER_NAME='" + this.containerName + "'");
                }
                dbCleaner = dialect.equals(DBConstants.DB_DIALECT_PGSQL) ? new PgSQLDBCleaner(jdbcConn, cleanScripts) : (dialect.equals(DBConstants.DB_DIALECT_INGRES) ? new IngresSQLDBCleaner(jdbcConn, cleanScripts) : (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI) ? new OracleDBCleaner(jdbcConn, cleanScripts) : new DBCleaner(jdbcConn, cleanScripts)));
            }
            return dbCleaner;
        }
        catch (NamingException e) {
            throw new CleanException(e);
        }
        catch (SQLException e) {
            throw new CleanException(e);
        }
    }

    static {
        if (STATISTICS_ENABLED) {
            LOG.info((Object)"The statistics of the component JDBCWorkspaceDataContainer has been enabled");
        }
    }

    class SharedConnectionFactory
    extends GenericConnectionFactory {
        private final Connection connection;

        SharedConnectionFactory(Connection connection, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
            super(null, null, null, null, null, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
            this.connection = connection;
        }

        public Connection getJdbcConnection() throws RepositoryException {
            return this.connection;
        }
    }
}

