/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.chromattic.api.ChromatticIOException;
import org.chromattic.api.NoSuchPropertyException;
import org.chromattic.api.Status;
import org.chromattic.api.TypeConversionException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.CloneableInputStream;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContextState;
import org.chromattic.core.ListType;
import org.chromattic.core.jcr.type.NodeTypeInfo;
import org.chromattic.core.jcr.type.PrimaryTypeInfo;
import org.chromattic.core.jcr.type.PropertyDefinitionInfo;
import org.chromattic.core.vt2.ValueDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentEntityContextState
extends EntityContextState {
    private final DomainSession session;
    private final Map<String, Object> propertyCache;
    private final Node node;
    private final PrimaryTypeInfo typeInfo;

    PersistentEntityContextState(Node node, DomainSession session) throws RepositoryException {
        this.session = session;
        this.propertyCache = session.domain.propertyCacheEnabled ? new HashMap() : null;
        this.node = node;
        this.typeInfo = session.domain.nodeInfoManager.getPrimaryTypeInfo(node.getPrimaryNodeType());
    }

    @Override
    String getId() {
        try {
            return this.node.getUUID();
        }
        catch (UnsupportedRepositoryOperationException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    String getLocalName() {
        try {
            return this.node.getName();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    Node getNode() {
        return this.node;
    }

    @Override
    DomainSession getSession() {
        return this.session;
    }

    @Override
    Status getStatus() {
        return Status.PERSISTENT;
    }

    @Override
    PrimaryTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    <V> V getPropertyValue(NodeTypeInfo nodeTypeInfo, String propertyName, ValueDefinition<?, V> vt) {
        try {
            PropertyDefinitionInfo def = nodeTypeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be loaded from node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            Object value = null;
            if (this.propertyCache != null) {
                value = this.propertyCache.get(propertyName);
            }
            if (value == null) {
                Value[] values;
                Property property = this.session.getSessionWrapper().getProperty(this.node, propertyName);
                Object jcrValue = property != null ? (def.isMultiple() ? ((values = property.getValues()).length == 0 ? null : values[0]) : property.getValue()) : null;
                if (jcrValue != null) {
                    if (vt == null) {
                        vt = ValueDefinition.get(jcrValue.getType());
                    }
                    value = vt.get((Value)jcrValue);
                    if (this.propertyCache != null && value instanceof InputStream) {
                        try {
                            value = new CloneableInputStream((InputStream)value);
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
            if (value == null) {
                if (vt != null) {
                    List<V> defaultValue = vt.getDefaultValue();
                    if (defaultValue != null && defaultValue.size() > 0) {
                        value = defaultValue.get(0);
                    }
                    if (value == null && vt.isPrimitive()) {
                        throw new NullPointerException("Cannot convert null to primitive type " + vt);
                    }
                }
            } else if (this.propertyCache != null) {
                if (value instanceof InputStream) {
                    value = ((CloneableInputStream)value).clone();
                } else if (value instanceof Date) {
                    value = ((Date)value).clone();
                }
            }
            return (V)value;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> List<V> getPropertyValues(NodeTypeInfo nodeTypeInfo, String propertyName, ValueDefinition<?, V> vt, ListType listType) {
        try {
            List<Object> list;
            PropertyDefinitionInfo def = nodeTypeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be from from node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            Property property = this.session.getSessionWrapper().getProperty(this.node, propertyName);
            Value[] values = property != null ? (def.isMultiple() ? property.getValues() : new Value[]{property.getValue()}) : null;
            if (vt == null && (vt = ValueDefinition.get(def.getType())) == null && values != null && values.length > 0) {
                vt = ValueDefinition.get(values[0].getType());
            }
            if (vt != null) {
                if (values != null) {
                    list = listType.create(vt, values.length);
                    for (int i = 0; i < values.length; ++i) {
                        Value value = values[i];
                        Object v = vt.get(value);
                        list.set(i, v);
                    }
                } else {
                    List<Object> defaultValue = vt.getDefaultValue();
                    if (defaultValue != null) {
                        if (def.isMultiple()) {
                            list = listType.create(vt, defaultValue.size());
                            for (int i = 0; i < defaultValue.size(); ++i) {
                                Object v = defaultValue.get(i);
                                list.set(i, v);
                            }
                        } else if (defaultValue.size() > 0) {
                            list = listType.create(vt, 1);
                            list.set(0, defaultValue.get(0));
                        } else {
                            list = listType.create(vt, 0);
                        }
                    } else {
                        list = null;
                    }
                }
            } else if (listType == ListType.LIST) {
                list = new ArrayList();
            } else {
                throw new AssertionError((Object)"this case is not possible");
            }
            return list;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> void setPropertyValue(NodeTypeInfo nodeTypeInfo, String propertyName, ValueDefinition<?, V> vt, V propertyValue) {
        try {
            Value jcrValue;
            PropertyDefinitionInfo def = nodeTypeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be set on node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            if (this.propertyCache != null && propertyValue instanceof InputStream && propertyValue instanceof CloneableInputStream) {
                try {
                    propertyValue = new CloneableInputStream((InputStream)propertyValue);
                }
                catch (IOException e) {
                    throw new ChromatticIOException("Could not read stream", e);
                }
            }
            if (propertyValue != null) {
                if (vt == null) {
                    vt = ValueDefinition.get(def.getType());
                    if (vt == null) {
                        vt = ValueDefinition.get(propertyValue);
                    }
                    if (vt == null) {
                        throw new TypeConversionException("Cannot convert object " + propertyValue + " no converter found");
                    }
                }
                int expectedType = def.getType();
                ValueFactory valueFactory = this.session.sessionWrapper.getSession().getValueFactory();
                jcrValue = vt.get(valueFactory, expectedType, propertyValue);
            } else {
                jcrValue = null;
            }
            if (def.isMultiple()) {
                if (jcrValue == null) {
                    this.node.setProperty(propertyName, new Value[0]);
                } else {
                    this.node.setProperty(propertyName, new Value[]{jcrValue});
                }
            } else {
                this.node.setProperty(propertyName, jcrValue);
            }
            if (this.propertyCache != null) {
                if (propertyValue != null) {
                    if (propertyValue instanceof InputStream) {
                        CloneableInputStream stream = (CloneableInputStream)propertyValue;
                        propertyValue = stream.clone();
                    } else if (propertyValue instanceof Date) {
                        propertyValue = ((Date)propertyValue).clone();
                    }
                    this.propertyCache.put(propertyName, propertyValue);
                } else {
                    this.propertyCache.remove(propertyName);
                }
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> void setPropertyValues(NodeTypeInfo nodeTypeInfo, String propertyName, ValueDefinition<?, V> vt, ListType listType, List<V> propertyValues) {
        try {
            Value[] jcrValues;
            PropertyDefinitionInfo def = nodeTypeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be set on node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            if (propertyValues != null) {
                if (propertyValues.isEmpty()) {
                    jcrValues = new Value[]{};
                } else {
                    V propertyValue;
                    if (vt == null && (vt = ValueDefinition.get(def.getType())) == null && (vt = ValueDefinition.get(propertyValue = propertyValues.get(0))) == null) {
                        throw new TypeConversionException("Cannot convert object " + propertyValue + " no converter found");
                    }
                    ValueFactory valueFactory = this.session.sessionWrapper.getSession().getValueFactory();
                    int size = propertyValues.size();
                    jcrValues = new Value[size];
                    for (int i = 0; i < size; ++i) {
                        Value jcrValue;
                        V element = propertyValues.get(i);
                        jcrValues[i] = jcrValue = vt.get(valueFactory, def.getType(), element);
                    }
                }
            } else {
                jcrValues = null;
            }
            if (jcrValues != null) {
                if (def.isMultiple()) {
                    this.node.setProperty(propertyName, jcrValues);
                } else {
                    if (jcrValues.length > 1) {
                        throw new IllegalArgumentException("Cannot update with an array of length greater than 1");
                    }
                    if (jcrValues.length == 1) {
                        this.node.setProperty(propertyName, jcrValues[0]);
                    } else {
                        this.node.setProperty(propertyName, (Value)null);
                    }
                }
            } else if (def.isMultiple()) {
                this.node.setProperty(propertyName, (Value[])null);
            } else {
                this.node.setProperty(propertyName, (Value)null);
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public String toString() {
        return "ObjectStatus[path=" + this.getPath() + ",status=" + Status.PERSISTENT + "]";
    }
}

