/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.infinispan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.TemplateConfigurationHelper;
import org.exoplatform.services.jcr.infinispan.ISPNCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISPNCacheFactory<K, V> {
    public static final String INFINISPAN_CONFIG = "infinispan-configuration";
    private final ConfigurationManager configurationManager;
    private final TemplateConfigurationHelper configurationHelper;
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.InfinispanCacheFactory");
    private static Map<GlobalConfiguration, EmbeddedCacheManager> CACHE_MANAGERS = new HashMap<GlobalConfiguration, EmbeddedCacheManager>();
    private static final MBeanServerLookup MBEAN_SERVER_LOOKUP = new MBeanServerLookup(){

        public MBeanServer getMBeanServer(Properties properties) {
            return ExoContainerContext.getTopContainer().getMBeanServer();
        }
    };

    public ISPNCacheFactory(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        this.configurationHelper = new ISPNCacheHelper(configurationManager);
    }

    public Cache<K, V> createCache(String regionId, MappedParametrizedObjectEntry parameterEntry) throws RepositoryConfigurationException {
        EmbeddedCacheManager manager;
        InputStream configStream;
        String configurationPath = parameterEntry.getParameterValue(INFINISPAN_CONFIG);
        log.info((Object)("Infinispan Cache configuration used: " + configurationPath));
        final String regionIdEscaped = regionId.replace("-", "_");
        try {
            configStream = this.configurationHelper.fillTemplate(configurationPath, parameterEntry.getParameters());
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException(e);
        }
        try {
            manager = (EmbeddedCacheManager)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<EmbeddedCacheManager>(){

                @Override
                public EmbeddedCacheManager run() throws IOException {
                    DefaultCacheManager manager = new DefaultCacheManager(configStream, false);
                    ISPNCacheFactory.this.loadJGroupsConfig(manager);
                    return ISPNCacheFactory.getUniqueInstance(regionIdEscaped, (EmbeddedCacheManager)manager);
                }
            });
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException(e);
        }
        PrivilegedAction action = new PrivilegedAction<Cache<K, V>>(){

            @Override
            public Cache<K, V> run() {
                return manager.getCache(regionIdEscaped);
            }
        };
        Cache cache = (Cache)SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJGroupsConfig(DefaultCacheManager manager) throws IOException {
        Properties p = manager.getGlobalConfiguration().getTransportProperties();
        if (p != null && p.containsKey("configurationFile")) {
            URL jgroupsConfigURL = null;
            InputStream jgroupsConfigInputStream = null;
            try {
                String configurationFile = p.getProperty("configurationFile");
                jgroupsConfigInputStream = this.configurationManager.getInputStream(configurationFile);
                jgroupsConfigURL = this.configurationManager.getResource(configurationFile);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (jgroupsConfigInputStream != null) {
                try {
                    log.info((Object)("Custom JGroups configuration set: " + jgroupsConfigURL));
                    p.setProperty("configurationXml", IOUtils.toString((InputStream)jgroupsConfigInputStream));
                    p.remove("configurationFile");
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    jgroupsConfigInputStream.close();
                    throw throwable;
                }
                jgroupsConfigInputStream.close();
                {
                }
            }
        }
    }

    private static synchronized EmbeddedCacheManager getUniqueInstance(String regionId, EmbeddedCacheManager manager) {
        GlobalConfiguration gc = manager.getGlobalConfiguration();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        gc.setClusterName(gc.getClusterName() + "_" + container.getContext().getName());
        gc.setCacheManagerName(gc.getCacheManagerName() + "_" + container.getContext().getName());
        gc.setMBeanServerLookupInstance(MBEAN_SERVER_LOOKUP);
        Configuration conf = manager.getDefaultConfiguration();
        if (CACHE_MANAGERS.containsKey(gc)) {
            manager = CACHE_MANAGERS.get(gc);
        } else {
            manager = new DefaultCacheManager(gc);
            CACHE_MANAGERS.put(gc, manager);
            if (log.isInfoEnabled()) {
                log.info((Object)("A new ISPN Cache Manager instance has been registered for the region " + regionId + " and the container " + container.getContext().getName()));
            }
        }
        manager.defineConfiguration(regionId, conf);
        if (log.isInfoEnabled()) {
            log.info((Object)("The region " + regionId + " has been registered for the container " + container.getContext().getName()));
        }
        return manager;
    }
}

