/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.util.PDFText2HTML;
import org.apache.pdfbox.util.PDFTextStripper;

public class ExtractText {
    private static final String PASSWORD = "-password";
    private static final String ENCODING = "-encoding";
    private static final String CONSOLE = "-console";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    private static final String SORT = "-sort";
    private static final String IGNORE_BEADS = "-ignoreBeads";
    private static final String HTML = "-html";
    private static final String FORCE = "-force";

    private ExtractText() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean toConsole = false;
        boolean toHTML = false;
        boolean force = false;
        boolean sort = false;
        boolean separateBeads = true;
        String password = "";
        String encoding = null;
        String pdfFile = null;
        String outputFile = null;
        String ext = ".txt";
        int startPage = 1;
        int endPage = Integer.MAX_VALUE;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(ENCODING)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                encoding = args[i];
                continue;
            }
            if (args[i].equals(START_PAGE)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                startPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(HTML)) {
                toHTML = true;
                ext = ".html";
                continue;
            }
            if (args[i].equals(SORT)) {
                sort = true;
                continue;
            }
            if (args[i].equals(IGNORE_BEADS)) {
                separateBeads = false;
                continue;
            }
            if (args[i].equals(END_PAGE)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                endPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(CONSOLE)) {
                toConsole = true;
                continue;
            }
            if (args[i].equals(FORCE)) {
                force = true;
                continue;
            }
            if (pdfFile == null) {
                pdfFile = args[i];
                continue;
            }
            outputFile = args[i];
        }
        if (pdfFile == null) {
            ExtractText.usage();
        } else {
            Writer output = null;
            PDDocument document = null;
            try {
                block28: {
                    try {
                        URL url = new URL(pdfFile);
                        document = PDDocument.load(url, force);
                        String fileName = url.getFile();
                        if (outputFile == null && fileName.length() > 4) {
                            outputFile = new File(fileName.substring(0, fileName.length() - 4) + ext).getName();
                        }
                    }
                    catch (MalformedURLException e) {
                        document = PDDocument.load(pdfFile, force);
                        if (outputFile != null || pdfFile.length() <= 4) break block28;
                        outputFile = pdfFile.substring(0, pdfFile.length() - 4) + ext;
                    }
                }
                if (document.isEncrypted()) {
                    StandardDecryptionMaterial sdm = new StandardDecryptionMaterial(password);
                    document.openProtection(sdm);
                    AccessPermission ap = document.getCurrentAccessPermission();
                    if (!ap.canExtractContent()) {
                        throw new IOException("You do not have permission to extract text");
                    }
                }
                if (encoding == null && toHTML) {
                    encoding = "UTF-8";
                }
                output = toConsole ? new OutputStreamWriter(System.out) : (encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding) : new OutputStreamWriter(new FileOutputStream(outputFile)));
                PDFTextStripper stripper = null;
                stripper = toHTML ? new PDFText2HTML(encoding) : new PDFTextStripper(encoding);
                stripper.setForceParsing(force);
                stripper.setSortByPosition(sort);
                stripper.setShouldSeparateByBeads(separateBeads);
                stripper.setStartPage(startPage);
                stripper.setEndPage(endPage);
                stripper.writeText(document, output);
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.ExtractText [OPTIONS] <PDF file> [Text File]\n  -password  <password>        Password to decrypt document\n  -encoding  <output encoding> (ISO-8859-1,UTF-16BE,UTF-16LE,...)\n  -console                     Send text to console instead of file\n  -html                        Output in HTML format instead of raw text\n  -sort                        Sort the text before writing\n  -ignoreBeads                 Disables the separation by beads\n  -force                       Enables pdfbox to ignore corrupt objects\n  -startPage <number>          The first page to start extraction(1 based)\n  -endPage <number>            The last page to extract(inclusive)\n  <PDF file>                   The PDF document to use\n  [Text File]                  The file to write the text to\n");
        System.exit(1);
    }
}

