/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLEntities;
import org.cyberneko.html.HTMLScanner;
import org.cyberneko.html.HTMLTagBalancer;
import org.cyberneko.html.filters.NamespaceBinder;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class NekoSimplifiedHtmlParser
extends GadgetHtmlParser {
    private static final Set<String> elements = ImmutableSet.of((Object[])new String[]{"html", "body", "head", "link", "img", "style", "script", "embed"});
    private final DOMImplementation documentFactory;

    @Inject
    public NekoSimplifiedHtmlParser(DOMImplementation documentFactory) {
        this.documentFactory = documentFactory;
    }

    protected Document parseDomImpl(String source) {
        DocumentHandler handler;
        try {
            handler = this.parseHtmlImpl(source);
        }
        catch (IOException ioe) {
            return null;
        }
        Document document = handler.getDocument();
        DocumentFragment fragment = handler.getFragment();
        this.normalizeFragment(document, fragment);
        return document;
    }

    protected DocumentFragment parseFragmentImpl(String source) throws GadgetException {
        DocumentHandler handler;
        try {
            handler = this.parseHtmlImpl(source);
        }
        catch (IOException ioe) {
            return null;
        }
        return handler.getFragment();
    }

    private DocumentHandler parseHtmlImpl(String source) throws IOException {
        HTMLConfiguration config = this.newConfiguration();
        HTMLScanner htmlScanner = new HTMLScanner();
        HTMLTagBalancer tagBalancer = new HTMLTagBalancer();
        DocumentHandler handler = this.newDocumentHandler(source, htmlScanner);
        if (config.getFeature("http://xml.org/sax/features/namespaces")) {
            NamespaceBinder namespaceBinder = new NamespaceBinder();
            namespaceBinder.setDocumentHandler((XMLDocumentHandler)handler);
            namespaceBinder.setDocumentSource((XMLDocumentSource)tagBalancer);
            namespaceBinder.reset((XMLComponentManager)config);
            tagBalancer.setDocumentHandler((XMLDocumentHandler)namespaceBinder);
        } else {
            tagBalancer.setDocumentHandler((XMLDocumentHandler)handler);
        }
        tagBalancer.setDocumentSource((XMLDocumentSource)htmlScanner);
        htmlScanner.setDocumentHandler((XMLDocumentHandler)tagBalancer);
        tagBalancer.reset((XMLComponentManager)config);
        htmlScanner.reset((XMLComponentManager)config);
        XMLInputSource inputSource = new XMLInputSource(null, null, null);
        inputSource.setEncoding("UTF-8");
        inputSource.setCharacterStream((Reader)new StringReader(source));
        htmlScanner.setInputSource(inputSource);
        htmlScanner.scanDocument(true);
        return handler;
    }

    protected HTMLConfiguration newConfiguration() {
        HTMLConfiguration config = new HTMLConfiguration();
        config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
        config.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
        config.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        config.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
        config.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
        return config;
    }

    protected DocumentHandler newDocumentHandler(String source, HTMLScanner scanner) {
        return new DocumentHandler(source);
    }

    protected boolean isElementImportant(QName qName) {
        return elements.contains(qName.rawname.toLowerCase());
    }

    protected class DocumentHandler
    implements XMLDocumentHandler {
        private final Stack<Node> elementStack = new Stack();
        private final StringBuilder builder;
        private boolean inEntity = false;
        private DocumentFragment documentFragment;
        private Document document;

        public DocumentHandler(String content) {
            this.builder = new StringBuilder(content.length() / 10);
        }

        public DocumentFragment getFragment() {
            return this.documentFragment;
        }

        public Document getDocument() {
            return this.document;
        }

        public void startDocument(XMLLocator xmlLocator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            this.document = NekoSimplifiedHtmlParser.this.documentFactory.createDocument(null, null, null);
            this.elementStack.clear();
            this.documentFragment = this.document.createDocumentFragment();
            this.elementStack.push(this.documentFragment);
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            this.builder.append("<?xml");
            if (version != null) {
                this.builder.append(" version=\"").append(version).append('\"');
            }
            if (encoding != null) {
                this.builder.append(" encoding=\"").append(encoding).append('\"');
            }
            if (standalone != null) {
                this.builder.append(" standalone=\"").append(standalone).append('\"');
            }
            this.builder.append('>');
        }

        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
            this.document = NekoSimplifiedHtmlParser.this.documentFactory.createDocument(null, null, NekoSimplifiedHtmlParser.this.documentFactory.createDocumentType(rootElement, publicId, systemId));
            this.elementStack.clear();
            this.documentFragment = this.document.createDocumentFragment();
            this.elementStack.push(this.documentFragment);
        }

        public void comment(XMLString text, Augmentations augs) throws XNIException {
            this.builder.append("<!--").append(text.ch, text.offset, text.length).append("-->");
        }

        public void processingInstruction(String s, XMLString xmlString, Augmentations augs) throws XNIException {
        }

        public void startElement(QName qName, XMLAttributes xmlAttributes, Augmentations augs) throws XNIException {
            if (NekoSimplifiedHtmlParser.this.isElementImportant(qName)) {
                Element element = this.startImportantElement(qName, xmlAttributes);
                this.elementStack.push(element);
            } else {
                this.startUnimportantElement(qName, xmlAttributes);
            }
        }

        public void emptyElement(QName qName, XMLAttributes xmlAttributes, Augmentations augs) throws XNIException {
            if (NekoSimplifiedHtmlParser.this.isElementImportant(qName)) {
                this.startImportantElement(qName, xmlAttributes);
            } else {
                this.startUnimportantElement(qName, xmlAttributes);
            }
        }

        protected void flushTextBuffer() {
            if (this.builder.length() > 0) {
                this.appendChild(this.document.createTextNode(this.builder.toString()));
                this.builder.setLength(0);
            }
        }

        private void startUnimportantElement(QName qName, XMLAttributes xmlAttributes) {
            this.builder.append('<').append(qName.rawname);
            for (int i = 0; i < xmlAttributes.getLength(); ++i) {
                String attributeName = xmlAttributes.getLocalName(i);
                this.builder.append(' ').append(attributeName).append("=\"");
                this.appendAttributeValue(xmlAttributes.getValue(i), HtmlSerialization.isUrlAttribute(qName, attributeName));
                this.builder.append('\"');
            }
            this.builder.append('>');
        }

        private Element startImportantElement(QName qName, XMLAttributes xmlAttributes) {
            this.flushTextBuffer();
            Element element = qName.uri != null ? this.document.createElementNS(qName.uri, qName.rawname) : this.document.createElement(qName.rawname);
            for (int i = 0; i < xmlAttributes.getLength(); ++i) {
                if (xmlAttributes.getURI(i) != null) {
                    element.setAttributeNS(xmlAttributes.getURI(i), xmlAttributes.getQName(i), xmlAttributes.getValue(i));
                    continue;
                }
                try {
                    element.setAttribute(xmlAttributes.getLocalName(i), xmlAttributes.getValue(i));
                    continue;
                }
                catch (DOMException e) {
                    switch (e.code) {
                        case 5: {
                            StringBuilder sb = new StringBuilder(e.getMessage());
                            sb.append("Around ...<");
                            if (qName.prefix != null) {
                                sb.append(qName.prefix);
                                sb.append(":");
                            }
                            sb.append(qName.localpart);
                            for (int j = 0; j < xmlAttributes.getLength(); ++j) {
                                if (!StringUtils.isNotBlank((String)xmlAttributes.getLocalName(j)) || !StringUtils.isNotBlank((String)xmlAttributes.getValue(j))) continue;
                                sb.append(' ');
                                sb.append(xmlAttributes.getLocalName(j));
                                sb.append("=\"");
                                sb.append(xmlAttributes.getValue(j)).append('\"');
                            }
                            sb.append("...");
                            throw new DOMException(5, sb.toString());
                        }
                    }
                    throw e;
                }
            }
            this.appendChild(element);
            return element;
        }

        private void appendAttributeValue(String text, boolean isUrl) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    this.builder.append("&quot;");
                    continue;
                }
                if (c == '&' && !isUrl) {
                    this.builder.append("&amp;");
                    continue;
                }
                this.builder.append(c);
            }
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier id, String encoding, Augmentations augs) throws XNIException {
            if (name.startsWith("#")) {
                try {
                    boolean hex = name.startsWith("#x");
                    int offset = hex ? 2 : 1;
                    int base = hex ? 16 : 10;
                    int value = Integer.parseInt(name.substring(offset), base);
                    String entity = HTMLEntities.get((int)value);
                    if (entity != null) {
                        name = entity;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.printEntity(name);
            this.inEntity = true;
        }

        private void printEntity(String name) {
            this.builder.append('&');
            this.builder.append(name);
            this.builder.append(';');
        }

        public void textDecl(String s, String s1, Augmentations augs) throws XNIException {
            this.builder.append(s);
        }

        public void endGeneralEntity(String s, Augmentations augs) throws XNIException {
            this.inEntity = false;
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (this.inEntity) {
                return;
            }
            this.builder.append(text.ch, text.offset, text.length);
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            this.builder.append(text.ch, text.offset, text.length);
        }

        public void endElement(QName qName, Augmentations augs) throws XNIException {
            if (NekoSimplifiedHtmlParser.this.isElementImportant(qName)) {
                this.flushTextBuffer();
                this.elementStack.pop();
            } else {
                this.builder.append("</").append(qName.rawname).append('>');
            }
        }

        public void startCDATA(Augmentations augs) throws XNIException {
        }

        public void endCDATA(Augmentations augs) throws XNIException {
        }

        public void endDocument(Augmentations augs) throws XNIException {
            this.flushTextBuffer();
            this.elementStack.pop();
        }

        public void setDocumentSource(XMLDocumentSource xmlDocumentSource) {
        }

        public XMLDocumentSource getDocumentSource() {
            return null;
        }

        protected final void appendChild(Node node) {
            this.elementStack.peek().appendChild(node);
        }
    }
}

