/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.repository.creation;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.jcr.ext.repository.creation.StorageCreationProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCreationProperties
implements StorageCreationProperties {
    private String serverUrl;
    private Map<String, String> connProps;
    private String dbScriptPath;
    private String dbUserName;
    private String dbPassword;

    public DBCreationProperties(String serverUrl, Map<String, String> connProps, String dbScriptPath, String dbUserName, String dbPassword) {
        this.serverUrl = serverUrl;
        this.connProps = connProps;
        this.dbScriptPath = dbScriptPath;
        this.dbUserName = dbUserName;
        this.dbPassword = dbPassword;
    }

    public DBCreationProperties() {
    }

    public String getDBScriptPath() {
        return this.dbScriptPath;
    }

    public String getDBUserName() {
        return this.dbUserName;
    }

    public String getDBPassword() {
        return this.dbPassword;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public Map<String, String> getConnProps() {
        return Collections.unmodifiableMap(this.connProps);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buf = this.serverUrl.getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        buf = this.dbScriptPath.getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        buf = this.dbUserName.getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        buf = this.dbPassword.getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        out.writeInt(this.connProps.size());
        for (Map.Entry<String, String> entry : this.connProps.entrySet()) {
            buf = entry.getKey().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
            buf = entry.getValue().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.serverUrl = new String(buf, "UTF-8");
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.dbScriptPath = new String(buf, "UTF-8");
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.dbUserName = new String(buf, "UTF-8");
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.dbPassword = new String(buf, "UTF-8");
        int count = in.readInt();
        this.connProps = new HashMap<String, String>(count);
        for (int i = 0; i < count; ++i) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            String key = new String(buf, "UTF-8");
            buf = new byte[in.readInt()];
            in.readFully(buf);
            String value = new String(buf, "UTF-8");
            this.connProps.put(key, value);
        }
    }
}

