/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;
import java.util.Vector;
import javax.swing.JPanel;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExitEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.util.Util;

public class Gossip
implements Runnable,
WindowListener,
ActionListener,
ChannelListener {
    private Graphics graphics = null;
    private Frame mainFrame = null;
    private JPanel panel = null;
    private JPanel sub_panel = null;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final Random random = new Random(System.currentTimeMillis());
    private Button gossip_button;
    private Button clear_button;
    private Button leave_button;
    private final Font default_font = new Font("Helvetica", 0, 12);
    private final String groupname = "GossipGroupDemo";
    private Channel channel = null;
    private Thread receiver = null;
    private int member_size = 1;
    private final Vector members = new Vector();
    private int red = 0;
    private int green = 0;
    private int blue = 0;
    private Color default_color = null;
    boolean first = true;
    final double subset = 0.1;
    Address local_addr = null;
    TrafficGenerator gen = null;
    long traffic_interval = 0L;

    public Gossip(String props, long traffic) throws Exception {
        this.channel = new JChannel(props);
        this.channel.addChannelListener(this);
        this.channel.setOpt(5, Boolean.TRUE);
        this.traffic_interval = traffic;
        if (this.traffic_interval > 0L) {
            this.gen = new TrafficGenerator();
            this.gen.start();
        }
    }

    public static void main(String[] args) {
        Gossip gossip = null;
        String props = null;
        long traffic = 0L;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                System.out.println("Gossip [-traffic_interval <interval in msecs>] [-help]");
                return;
            }
            if (!"-traffic_interval".equals(args[i])) continue;
            traffic = Long.parseLong(args[++i]);
        }
        props = "UDP(mcast_addr=224.10.10.100;mcast_port=5678;ip_ttl=32):PING:pbcast.FD(timeout=3000):VERIFY_SUSPECT(timeout=2000;num_msgs=2):pbcast.PBCAST(desired_avg_gossip=8000;mcast_gossip=true;gc_lag=30;max_queue=20):UNICAST:FRAG:pbcast.GMS";
        try {
            gossip = new Gossip(props, traffic);
            gossip.go();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(0);
        }
    }

    private void selectColor() {
        this.red = Math.abs(this.random.nextInt()) % 255;
        this.green = Math.abs(this.random.nextInt()) % 255;
        this.blue = Math.abs(this.random.nextInt()) % 255;
        this.default_color = new Color(this.red, this.green, this.blue);
    }

    public void go() {
        try {
            this.channel.connect("GossipGroupDemo");
            this.local_addr = this.channel.getLocalAddress();
            this.startThread();
            this.mainFrame = new Frame();
            this.panel = new MyPanel();
            this.sub_panel = new JPanel();
            this.mainFrame.setSize(250, 250);
            this.mainFrame.add("Center", this.panel);
            this.clear_button = new Button("Clear");
            this.clear_button.setFont(this.default_font);
            this.clear_button.addActionListener(this);
            this.gossip_button = new Button("Gossip");
            this.gossip_button.setFont(this.default_font);
            this.gossip_button.addActionListener(this);
            this.leave_button = new Button("Leave & Exit");
            this.leave_button.setFont(this.default_font);
            this.leave_button.addActionListener(this);
            this.sub_panel.add("South", this.gossip_button);
            this.sub_panel.add("South", this.clear_button);
            this.sub_panel.add("South", this.leave_button);
            this.mainFrame.add("South", this.sub_panel);
            this.mainFrame.addWindowListener(this);
            this.mainFrame.setVisible(true);
            this.setTitle();
            this.graphics = this.panel.getGraphics();
            this.graphics.setColor(this.default_color);
            this.mainFrame.setBackground(Color.white);
            this.mainFrame.pack();
            this.gossip_button.setForeground(Color.blue);
            this.clear_button.setForeground(Color.blue);
            this.leave_button.setForeground(Color.blue);
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    void startThread() {
        this.receiver = new Thread((Runnable)this, "GossipThread");
        this.receiver.setPriority(10);
        this.receiver.start();
    }

    void setTitle() {
        String title = "";
        if (this.local_addr != null) {
            title = title + this.local_addr;
        }
        title = title + " (" + this.member_size + ") mbrs";
        this.mainFrame.setTitle(title);
    }

    @Override
    public void run() {
        Message msg = null;
        boolean fl = true;
        block8: while (fl) {
            try {
                Object tmp = this.channel.receive(0L);
                if (tmp == null) continue;
                if (tmp instanceof View) {
                    View v = (View)tmp;
                    this.member_size = v.size();
                    Vector<Address> mbrs = v.getMembers();
                    this.members.removeAllElements();
                    for (int i = 0; i < mbrs.size(); ++i) {
                        this.members.addElement(mbrs.elementAt(i));
                    }
                    if (this.mainFrame == null) continue;
                    this.setTitle();
                    continue;
                }
                if (tmp instanceof ExitEvent) break;
                if (!(tmp instanceof Message)) continue;
                msg = (Message)tmp;
                Command comm = null;
                Object obj = msg.getObject();
                if (obj instanceof Command) {
                    comm = (Command)obj;
                } else if (obj instanceof Message) {
                    System.out.println("*** Message is " + Util.printMessage((Message)obj));
                    Util.dumpStack(true);
                } else {
                    if (obj != null) {
                        System.out.println("obj is " + obj.getClass() + ", hdrs are" + msg.printObjectHeaders());
                    } else {
                        System.out.println("hdrs are" + msg.printObjectHeaders());
                    }
                    Util.dumpStack(true);
                }
                switch (comm.mode) {
                    case 1: {
                        if (this.graphics == null) continue block8;
                        this.colorPanel(comm.r, comm.g, comm.b);
                        comm.not_seen.removeElement(this.local_addr);
                        if (comm.not_seen.size() <= 0) continue block8;
                        Vector v = Util.pickSubset(comm.not_seen, 0.1);
                        this.out.reset();
                        ObjectOutputStream os = new ObjectOutputStream(this.out);
                        os.writeObject(comm);
                        os.flush();
                        for (int i = 0; i < v.size(); ++i) {
                            this.channel.send(new Message((Address)v.elementAt(i), null, this.out.toByteArray()));
                        }
                        continue block8;
                    }
                    case 2: {
                        this.clearPanel();
                        continue block8;
                    }
                    default: {
                        System.err.println("***** Gossip.run(): received invalid draw command " + comm.mode);
                    }
                }
            }
            catch (ChannelNotConnectedException not) {
                System.err.println("Gossip: " + not);
                break;
            }
            catch (ChannelClosedException closed) {
                System.err.println("Gossip: channel was closed");
                break;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void clearPanel() {
        Rectangle bounds = null;
        if (this.panel == null || this.graphics == null) {
            return;
        }
        bounds = this.panel.getBounds();
        this.graphics.clearRect(0, 0, bounds.width, bounds.height);
    }

    public void colorPanel(int r, int g, int b) {
        if (this.graphics != null) {
            this.red = r;
            this.green = g;
            this.blue = b;
            this.graphics.setColor(new Color(this.red, this.green, this.blue));
            Rectangle bounds = this.panel.getBounds();
            this.graphics.fillRect(0, 0, bounds.width, bounds.height);
            this.graphics.setColor(this.default_color);
        }
    }

    void sendGossip() {
        int[] tmp = new int[]{0};
        Vector dests = (Vector)this.members.clone();
        try {
            this.selectColor();
            dests.removeElement(this.local_addr);
            dests = Util.pickSubset(dests, 0.1);
            if (dests == null || dests.size() == 0) {
                this.colorPanel(this.red, this.green, this.blue);
                return;
            }
            this.colorPanel(this.red, this.green, this.blue);
            Command comm = new Command(1, this.red, this.green, this.blue);
            comm.not_seen = (Vector)this.members.clone();
            comm.not_seen.removeElement(this.local_addr);
            this.out.reset();
            ObjectOutputStream os = new ObjectOutputStream(this.out);
            os.writeObject(comm);
            os.flush();
            for (int i = 0; i < dests.size(); ++i) {
                this.channel.send(new Message((Address)dests.elementAt(i), null, this.out.toByteArray()));
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void sendClearPanelMsg() {
        int[] tmp = new int[]{0};
        Command comm = new Command(2);
        try {
            this.out.reset();
            ObjectOutputStream os = new ObjectOutputStream(this.out);
            os.writeObject(comm);
            os.flush();
            this.channel.send(new Message(null, null, this.out.toByteArray()));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Gossip".equals(command)) {
            this.sendGossip();
        } else if ("Clear".equals(command)) {
            this.sendClearPanelMsg();
        } else if ("Leave & Exit".equals(command)) {
            try {
                this.channel.disconnect();
                this.channel.close();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            this.mainFrame.setVisible(false);
            System.exit(0);
        } else {
            System.out.println("Unknown action");
        }
    }

    @Override
    public void channelConnected(Channel channel) {
        if (this.first) {
            this.first = false;
        } else {
            this.startThread();
        }
    }

    @Override
    public void channelDisconnected(Channel channel) {
    }

    @Override
    public void channelClosed(Channel channel) {
    }

    @Override
    public void channelShunned() {
        System.out.println("----> channelShunned()");
    }

    @Override
    public void channelReconnected(Address new_addr) {
        System.out.println("----> channelReconnected(" + new_addr + ')');
        this.local_addr = new_addr;
    }

    private class MyPanel
    extends JPanel {
        final Dimension preferred_size = new Dimension(200, 200);

        private MyPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferred_size;
        }
    }

    private class TrafficGenerator
    implements Runnable {
        Thread generator = null;

        private TrafficGenerator() {
        }

        public void start() {
            if (this.generator == null) {
                this.generator = new Thread((Runnable)this, "TrafficGeneratorThread");
                this.generator.start();
            }
        }

        public void stop() {
            if (this.generator != null) {
                this.generator = null;
            }
            this.generator = null;
        }

        @Override
        public void run() {
            while (this.generator != null) {
                Util.sleep(Gossip.this.traffic_interval);
                if (this.generator == null) continue;
                Gossip.this.sendGossip();
            }
        }
    }

    private static class Command
    implements Serializable {
        static final int GOSSIP = 1;
        static final int CLEAR = 2;
        final int mode;
        int r = 0;
        int g = 0;
        int b = 0;
        Vector not_seen = new Vector();

        Command(int mode) {
            this.mode = mode;
        }

        Command(int mode, int r, int g, int b) {
            this.mode = mode;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            switch (this.mode) {
                case 1: {
                    ret.append("GOSSIP(" + this.r + '|' + this.g + '|' + this.b);
                    break;
                }
                case 2: {
                    ret.append("CLEAR");
                    break;
                }
                default: {
                    return "<undefined>";
                }
            }
            ret.append(", not_seen=" + this.not_seen);
            return ret.toString();
        }
    }
}

