/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionValue;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataImpl;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeConverter {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.NodeTypeConverter");
    private final LocationFactory locationFactory;
    protected final String accessControlPolicy;

    public NodeTypeConverter(LocationFactory locationFactory, String accessControlPolicy) {
        this.locationFactory = locationFactory;
        this.accessControlPolicy = accessControlPolicy;
    }

    public List<NodeTypeData> convertFromValueToData(List<NodeTypeValue> ntvalues) throws RepositoryException {
        ArrayList<NodeTypeData> nodeTypeDataList = new ArrayList<NodeTypeData>();
        for (NodeTypeValue ntvalue : ntvalues) {
            List<String> nsupertypes;
            if (this.accessControlPolicy.equals("disable") && ((nsupertypes = ntvalue.getDeclaredSupertypeNames()) != null && nsupertypes.contains("exo:privilegeable") || ntvalue.getName().equals("exo:privilegeable"))) {
                this.log.warn((Object)("Node type " + ntvalue.getName() + " is not register due to DISABLE control policy"));
                break;
            }
            ntvalue.validateNodeType();
            InternalQName ntName = this.locationFactory.parseJCRName(ntvalue.getName()).getInternalName();
            List<String> stlist = ntvalue.getDeclaredSupertypeNames();
            InternalQName[] supertypes = new InternalQName[stlist.size()];
            for (int i = 0; i < stlist.size(); ++i) {
                supertypes[i] = this.locationFactory.parseJCRName(stlist.get(i)).getInternalName();
            }
            List<PropertyDefinitionValue> pdlist = ntvalue.getDeclaredPropertyDefinitionValues();
            PropertyDefinitionData[] props = new PropertyDefinitionData[pdlist.size()];
            for (int i = 0; i < pdlist.size(); ++i) {
                PropertyDefinitionData pd;
                PropertyDefinitionValue v = pdlist.get(i);
                props[i] = pd = new PropertyDefinitionData(this.locationFactory.parseJCRName(v.getName()).getInternalName(), ntName, v.isAutoCreate(), v.isMandatory(), v.getOnVersion(), v.isReadOnly(), v.getRequiredType(), this.safeListToArray(v.getValueConstraints()), this.safeListToArray(v.getDefaultValueStrings()), v.isMultiple());
            }
            List<NodeDefinitionValue> ndlist = ntvalue.getDeclaredChildNodeDefinitionValues();
            NodeDefinitionData[] nodes = new NodeDefinitionData[ndlist.size()];
            for (int i = 0; i < ndlist.size(); ++i) {
                NodeDefinitionData nd;
                NodeDefinitionValue v = ndlist.get(i);
                List<String> rnts = v.getRequiredNodeTypeNames();
                InternalQName[] requiredNTs = new InternalQName[rnts.size()];
                for (int ri = 0; ri < rnts.size(); ++ri) {
                    requiredNTs[ri] = this.locationFactory.parseJCRName(rnts.get(ri)).getInternalName();
                }
                InternalQName defaultNodeName = null;
                if (v.getDefaultNodeTypeName() != null) {
                    defaultNodeName = this.locationFactory.parseJCRName(v.getDefaultNodeTypeName()).getInternalName();
                }
                nodes[i] = nd = new NodeDefinitionData(this.locationFactory.parseJCRName(v.getName()).getInternalName(), ntName, v.isAutoCreate(), v.isMandatory(), v.getOnVersion(), v.isReadOnly(), requiredNTs, defaultNodeName, v.isSameNameSiblings());
            }
            InternalQName primaryItemName = null;
            if (ntvalue.getPrimaryItemName() != null) {
                primaryItemName = this.locationFactory.parseJCRName(ntvalue.getPrimaryItemName()).getInternalName();
            }
            NodeTypeDataImpl nodeTypeData = new NodeTypeDataImpl(ntName, primaryItemName, ntvalue.isMixin(), ntvalue.isOrderableChild(), supertypes, props, nodes);
            nodeTypeDataList.add(nodeTypeData);
        }
        return nodeTypeDataList;
    }

    public Map<InternalQName, NodeTypeData> convertToMap(List<NodeTypeData> ntvalues) {
        HashMap<InternalQName, NodeTypeData> result = new HashMap<InternalQName, NodeTypeData>();
        for (NodeTypeData nodeTypeData : ntvalues) {
            result.put(nodeTypeData.getName(), nodeTypeData);
        }
        return result;
    }

    private String[] safeListToArray(List<String> v) {
        return v != null ? v.toArray(new String[v.size()]) : new String[]{};
    }
}

