/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.Map;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.url.ComponentURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalURLBuilder
extends URLBuilder<UIComponent> {
    private final ComponentURL url;

    public PortalURLBuilder(PortalRequestContext ctx, ComponentURL url) {
        String path = ctx.getNodePath();
        url.setPath(path);
        this.url = url;
    }

    public String createAjaxURL(UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params) {
        return this.createURL(true, targetComponent, action, confirm, targetBeanId, params);
    }

    public String createURL(UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params) {
        return this.createURL(false, targetComponent, action, confirm, targetBeanId, params);
    }

    private String createURL(boolean ajax, UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params) {
        Map queryParameters = this.url.getQueryParameters();
        if (queryParameters != null) {
            queryParameters.clear();
        }
        this.url.setAjax(Boolean.valueOf(ajax));
        this.url.setConfirm(confirm);
        this.url.setResource(targetComponent);
        this.url.setAction(action);
        this.url.setTargetBeanId(targetBeanId);
        if (params != null) {
            for (Parameter param : params) {
                this.url.setQueryParameterValue(param.getName(), param.getValue());
            }
        }
        if (this.removeLocale) {
            this.url.setLocale(null);
        } else if (this.locale != null) {
            this.url.setLocale(this.locale);
        }
        return this.url.toString();
    }
}

